/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.AbnormalPersonnelEmployeeType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.AbnormalPersonnelException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.DataOperationTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.RetryableTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.tenant.domain.conditions.EmployeeLeaveCondition;
import com.bcxin.tenant.domain.conditions.TenantUserSameValidator;
import com.bcxin.tenant.domain.conditions.requests.TenantUserSameCheckRequest;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.configs.TenantUserConfig;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantAbnormalPersonnelEntity;
import com.bcxin.tenant.domain.enums.EmployeeEventType;
import com.bcxin.tenant.domain.events.EmployeeUpdatedEvent;
import com.bcxin.tenant.domain.exceptions.TenantExceptionConverter;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.dtos.EmployeeConditionDto;
import com.bcxin.tenant.domain.repositories.CompositeDataRepository;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.TenantAbnormalPersonnelRepository;
import com.bcxin.tenant.domain.services.EmployeeService;
import com.bcxin.tenant.domain.services.commands.BackEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.BatchAssignEmployeeSuperiorCommand;
import com.bcxin.tenant.domain.services.commands.BatchImportEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.BatchLeaveEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.BatchLeaveEmployeeExcelCommand;
import com.bcxin.tenant.domain.services.commands.BatchMoveEmployeesCommand;
import com.bcxin.tenant.domain.services.commands.CreateEmployeeRequestCommand;
import com.bcxin.tenant.domain.services.commands.UpdateEmployeeRequestCommand;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EmployeeServiceImpl
implements EmployeeService {
    private final OrganizationRepository organizationRepository;
    private final UnitWork unitWork;
    private final DepartmentRepository departmentRepository;
    private final EmployeeRepository employeeRepository;
    private final CompositeDataRepository compositeDataRepository;
    private final TenantDbReader tenantDbReader;
    private final EventDispatcher eventDispatcher;
    private final EmployeeLeaveCondition condition;
    private final EnvConfig envConfig;
    private final TenantUserSameValidator tenantUserSameValidator;
    private final TenantAbnormalPersonnelRepository tenantAbnormalPersonnelRepository;
    private final TenantUserConfig tenantUserConfig;

    public EmployeeServiceImpl(OrganizationRepository organizationRepository, UnitWork unitWork, DepartmentRepository departmentRepository, EmployeeRepository employeeRepository, CompositeDataRepository compositeDataRepository, TenantDbReader tenantDbReader, EventDispatcher eventDispatcher, EmployeeLeaveCondition condition, EnvConfig envConfig, TenantUserSameValidator tenantUserSameValidator, TenantAbnormalPersonnelRepository tenantAbnormalPersonnelRepository, TenantUserConfig tenantUserConfig) {
        this.organizationRepository = organizationRepository;
        this.unitWork = unitWork;
        this.departmentRepository = departmentRepository;
        this.employeeRepository = employeeRepository;
        this.compositeDataRepository = compositeDataRepository;
        this.tenantDbReader = tenantDbReader;
        this.eventDispatcher = eventDispatcher;
        this.condition = condition;
        this.envConfig = envConfig;
        this.tenantUserSameValidator = tenantUserSameValidator;
        this.tenantAbnormalPersonnelRepository = tenantAbnormalPersonnelRepository;
        this.tenantUserConfig = tenantUserConfig;
    }

    @Override
    public String dispatch(CreateEmployeeRequestCommand command) {
        boolean isRequiredPhoneAsLoginName = this.envConfig.isRequiredPhoneAsLoginName();
        Optional organizationOptional = this.organizationRepository.findById(command.getOrganizationId());
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException(String.format("\u7ec4\u7ec7(%s)\u4fe1\u606f\u65e0\u6548!", command.getOrganizationId()));
        }
        OrganizationEntity organization = (OrganizationEntity)((Object)organizationOptional.get());
        command.validate(isRequiredPhoneAsLoginName, this.tenantUserConfig);
        if (command.getAbnormalPersonnelEmployeeType().getCode() != AbnormalPersonnelEmployeeType.NOT_VERIFY.getCode() && StringUtils.hasLength((String)organization.getSuperviseRegionCode()) && organization.getSuperviseRegionCode().length() > 1) {
            String regionCode = organization.getSuperviseRegionCode().substring(0, 2).concat("0000");
            List<TenantAbnormalPersonnelEntity> abnormalPersonnelList = this.tenantAbnormalPersonnelRepository.findByIdCardNumAndRestrictedRegionCode(command.getCredential().getNumber(), regionCode);
            if (CollectionUtil.isNotEmpty(abnormalPersonnelList)) {
                TenantAbnormalPersonnelEntity abnormalPersonnel = abnormalPersonnelList.get(0);
                int restrictedType = abnormalPersonnel.getRestrictedType();
                if (command.getOccupationType() == OccupationType.Normal) {
                    restrictedType = 1;
                }
                if (restrictedType == 1) {
                    if (command.getAbnormalPersonnelEmployeeType().getCode() != AbnormalPersonnelEmployeeType.NEED_VERIFY_REMIND_CONFIRM.getCode()) {
                        throw new AbnormalPersonnelException("1000601", String.format("\u8be5\u4eba\u5458\u3010%s\u3011\u4e3a\u4ece\u4e1a\u5f02\u5e38\u4eba\u5458\uff0c\u662f\u5426\u786e\u8ba4\u5f55\u7528\uff01", command.getName()), null);
                    }
                } else if (restrictedType == 2) {
                    throw new AbnormalPersonnelException("1000602", String.format("\u8be5\u4eba\u5458\u3010%s\u3011\u4e0d\u7b26\u5408\u62c5\u4efb\u4fdd\u5b89\u5458\uff0c\u65e0\u6cd5\u5f55\u5165\u7cfb\u7edf\uff01", command.getName()), null);
                }
            }
        }
        this.tenantUserSameValidator.validate(Collections.singleton(TenantUserSameCheckRequest.create(command.getCredential().getType(), command.getCredential().getNumber(), command.getTelephone())));
        DepartmentEntity department = this.getAndValidateDepartment(organization, command.getDepartId());
        AtomicReference employeeAto = new AtomicReference();
        ArrayList uniqueDataConstraints = new ArrayList();
        try {
            this.unitWork.executeTran(() -> {
                employeeAto.set(EmployeeEntity.create(this.eventDispatcher, organization, department, command.getName(), command.getTelephone(), command.getPassword(), command.getPosition(), command.getHiredDate(), MasterSlaveType.Normal, command.getCredential().getType(), command.getCredential().getNumber(), command.getOccupationType(), true, command.getOperator()));
                this.employeeRepository.save((EntityAbstract)employeeAto.get());
                ((EmployeeEntity)((Object)((Object)employeeAto.get()))).dispatchAfterCreatedEvent(isRequiredPhoneAsLoginName);
            });
            return ((EmployeeEntity)((Object)employeeAto.get())).getId();
        }
        catch (Exception ex) {
            TenantExceptionAbstract tenantExceptionAbstract = TenantExceptionConverter.cast(ex);
            if (tenantExceptionAbstract != null && tenantExceptionAbstract instanceof ConflictTenantException) {
                if (employeeAto.get() != null) {
                    this.unitWork.detach((IAggregate)employeeAto.get());
                }
                uniqueDataConstraints.forEach(udi -> this.unitWork.detach((IAggregate)udi));
                EmployeeEntity selectedEmployee = this.employeeRepository.getByIdNum(organization.getId(), command.getCredential().getNumber());
                if (selectedEmployee == null) {
                    throw ex;
                }
                if (selectedEmployee.getStatus() == EmploymentStatus.OffJob) {
                    this.unitWork.executeTran(() -> {
                        this.departmentRepository.clearDuplicatedEmployeeRelationByEmployeeIds(Collections.singleton(selectedEmployee.getId()));
                        selectedEmployee.back(this.eventDispatcher, department, command.getOccupationType(), command.getHiredDate(), command.getOperator(), false);
                        this.employeeRepository.save(selectedEmployee);
                    });
                }
                return selectedEmployee.getId();
            }
            throw tenantExceptionAbstract;
        }
    }

    @Override
    public void dispatch(UpdateEmployeeRequestCommand command) {
        command.validate();
        Optional employeeOptional = this.employeeRepository.findById(command.getId());
        if (employeeOptional == null) {
            throw new NotFoundTenantException(String.format("\u804c\u5458(%s)\u65e0\u6548", command.getId()));
        }
        EmployeeEntity employee = (EmployeeEntity)((Object)employeeOptional.get());
        Collection<DepartmentEntity> departments = this.getAndValidateDepartments(employee.getOrganization(), command.getDepartIds());
        if (departments != null && departments.size() > 0) {
            employee.joinDepartments(departments, MasterSlaveType.Normal);
        }
        EmployeeEntity superor = null;
        if (StringUtils.hasLength((String)command.getSuperiorId()) && (superor = this.employeeRepository.getByOrganIdAndId(command.getOrganizationId(), command.getSuperiorId())) == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u4e0a\u7ea7\u4fe1\u606f");
        }
        employee.change(command.getHiredTime(), command.getPosition(), command.getPositiveDate(), superor, command.getInterview(), command.getPersonStatus(), command.getProbation(), command.getPlanPositiveDate(), command.getSalary());
        this.unitWork.executeTran(() -> {
            this.employeeRepository.save(employee);
            this.eventDispatcher.dispatch((DomainEventAbstract)EmployeeUpdatedEvent.create(employee, EmployeeEventType.Other, Timestamp.from(Instant.now()), "\u4fee\u6539\u4fe1\u606f"));
        });
    }

    @Override
    public void dispatch(BatchMoveEmployeesCommand command) {
        command.validate();
        Collection<EmployeeEntity> employeeEntities = this.employeeRepository.getByIds(command.getOrganId(), command.getEmployeeIds());
        Collection notExistsEmployees = command.getEmployeeIds().stream().filter(emId -> !employeeEntities.stream().anyMatch(ix -> ix.getId().equals(emId))).collect(Collectors.toList());
        if (notExistsEmployees.size() > 0) {
            throw new BadTenantException(String.format("\u627e\u4e0d\u5230\u804c\u5458(%s)\u4fe1\u606f", notExistsEmployees.stream().collect(Collectors.joining(","))));
        }
        Collection<DepartmentEntity> destDepartments = this.departmentRepository.getByIds(command.getOrganId(), Collections.singleton(command.getDestDepartId()));
        if (CollectionUtils.isEmpty(destDepartments)) {
            throw new BadTenantException(String.format("\u627e\u4e0d\u5230\u8be5\u90e8\u95e8(%s)\u4fe1\u606f", command.getDestDepartId()));
        }
        try {
            this.unitWork.executeTran(() -> {
                DepartmentEntity department = (DepartmentEntity)((Object)((Object)destDepartments.stream().findFirst().get()));
                employeeEntities.forEach(ix -> {
                    ix.move2Department(department);
                    this.employeeRepository.save((EntityAbstract)ix);
                    this.eventDispatcher.dispatch((DomainEventAbstract)EmployeeUpdatedEvent.create(ix, EmployeeEventType.Other, Timestamp.from(Instant.now()), "\u8f6c\u79fb\u90e8\u95e8"));
                });
            });
        }
        catch (Exception ex) {
            TenantExceptionAbstract exceptionAbstract = TenantExceptionConverter.cast(ex);
            if (exceptionAbstract instanceof ConflictTenantException) {
                this.unitWork.detachAll();
                String detailMsg = ExceptionUtil.getStackMessage((Throwable)ex);
                if (detailMsg.contains("unique_department_employee_relation_department_id_employee_id")) {
                    this.unitWork.executeTran(() -> this.departmentRepository.clearDuplicatedEmployeeRelationByEmployeeIdsAndDepartId(command.getEmployeeIds(), command.getDestDepartId()));
                    throw new RetryableTenantException("\u7528\u6237\u5df2\u7ecf\u518d\u8be5\u90e8\u95e8, \u65e0\u6cd5\u91cd\u590d\u8f6c\u79fb, \u8bf7\u8fdb\u884c\u5220\u9664", ex);
                }
            }
            throw exceptionAbstract;
        }
    }

    @Override
    public String dispatch(BatchImportEmployeeCommand command) {
        command.validate(this.tenantUserConfig);
        Optional organizationOptional = this.organizationRepository.findById(command.getOrganizationId());
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException("\u7ec4\u7ec7\u65e0\u6548!");
        }
        OrganizationEntity organization = (OrganizationEntity)((Object)organizationOptional.get());
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        if (currentUser == null) {
            throw new UnAuthorizedTenantException("\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
        boolean isMaster = currentUser.isMaster();
        boolean isDepartAdmin = currentUser.isDepartAdmin();
        if (!isMaster && !isDepartAdmin) {
            throw new UnAuthorizedTenantException("\u53ea\u6709\u7ec4\u7ec7\u7ba1\u7406\u5458\u6216\u90e8\u95e8\u7ba1\u7406\u5458\u6709\u6743\u9650\u64cd\u4f5c");
        }
        if (StringUtils.hasLength((String)organization.getSuperviseRegionCode()) && organization.getSuperviseRegionCode().length() > 1) {
            String regionCode = organization.getSuperviseRegionCode().substring(0, 2).concat("0000");
            List<String> numberList = command.getCommandItems().stream().map(commandItem -> commandItem.getDataItem().getCredentialNumber()).collect(Collectors.toList());
            List<TenantAbnormalPersonnelEntity> abnormalPersonnelList = this.tenantAbnormalPersonnelRepository.findByIdCardNumInAndRestrictedRegionCode(numberList, regionCode);
            if (CollectionUtil.isNotEmpty(abnormalPersonnelList)) {
                Map<String, List<TenantAbnormalPersonnelEntity>> abnormalPersonnelListMap = abnormalPersonnelList.stream().collect(Collectors.groupingBy(TenantAbnormalPersonnelEntity::getIdCardNum));
                for (BatchImportEmployeeCommand.EmployeeCommandItem commandItem2 : command.getCommandItems()) {
                    List<TenantAbnormalPersonnelEntity> personnelList = abnormalPersonnelListMap.get(commandItem2.getDataItem().getCredentialNumber());
                    if (!CollectionUtil.isNotEmpty(personnelList)) continue;
                    TenantAbnormalPersonnelEntity abnormalPersonnel = personnelList.get(0);
                    int restrictedType = abnormalPersonnel.getRestrictedType();
                    if (commandItem2.getOccupationType() == OccupationType.Normal) {
                        restrictedType = 1;
                    }
                    if (restrictedType == 1) {
                        commandItem2.addError("\u8be5\u4eba\u5458\u4e3a\u4ece\u4e1a\u5f02\u5e38\u4eba\u5458\uff0c\u4e0d\u80fd\u6279\u91cf\u5bfc\u5165\uff0c\u8bf7\u5355\u4e2a\u6dfb\u52a0\uff01");
                        continue;
                    }
                    if (restrictedType != 2) continue;
                    commandItem2.addError("\u8be5\u4eba\u5458\u4e0d\u7b26\u5408\u62c5\u4efb\u4fdd\u5b89\u5458\uff0c\u65e0\u6cd5\u5f55\u5165\u7cfb\u7edf\uff01");
                }
            }
        }
        String importedDataId = this.compositeDataRepository.execute(organization, command);
        return importedDataId;
    }

    @Override
    public void dispatch(BatchLeaveEmployeeCommand command) {
        TenantUserContext userContext;
        boolean isScheduledLeave = !StringUtils.isEmpty((Object)command.getNote()) && command.getNote().contains("\u4eba\u5458\u81ea\u52a8\u79bb\u804c");
        command.validate();
        if (!isScheduledLeave && (userContext = TenantContext.getInstance().getUserContext()) != null && userContext.get() != null && userContext.get().getEmployeeId() != null && command.getIds().contains(userContext.get().getEmployeeId())) {
            throw new DataOperationTenantException("\u4e0d\u5141\u8bb8\u4e3a\u81ea\u5df1\u529e\u7406\u79bb\u804c", "1000003", (Object)userContext.get().getEmployeeId());
        }
        Collection<EmployeeEntity> employees = this.employeeRepository.getByIds(command.getOrganizationId(), command.getIds());
        Collection notExistsEmployees = command.getIds().stream().filter(id -> !employees.stream().anyMatch(ix -> ix.getId().equals(id))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notExistsEmployees)) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u804c\u5458(%s)\u4fe1\u606f", (Object)notExistsEmployees.stream().collect(Collectors.joining(",")));
        }
        String offJobEmployeeIds = employees.stream().filter(ii -> ii.getStatus() == EmploymentStatus.OffJob).map(ii -> ii.getId()).collect(Collectors.joining(","));
        if (StringUtils.hasLength((String)offJobEmployeeIds)) {
            throw new NotAllowedTenantException(String.format("\u8be5\u804c\u5458(%s)\u5df2\u7ecf\u5904\u4e8e\u79bb\u804c\u72b6\u6001", offJobEmployeeIds));
        }
        String operateId = null;
        String operateName = null;
        if (!isScheduledLeave) {
            TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
            if (currentUser == null) {
                throw new ForbidTenantException("\u5fc5\u987b\u6709\u4eba\u6765\u64cd\u4f5c\u79bb\u804c");
            }
            operateId = currentUser.getId();
            operateName = currentUser.getName();
        } else {
            List<EmployeeEntity> adminList = this.employeeRepository.getAdminByOrganId(command.getOrganizationId());
            if (CollectionUtil.isNotEmpty(adminList)) {
                operateId = adminList.get(0).getTenantUser().getId();
                operateName = adminList.get(0).getTenantUser().getName();
            }
        }
        List<EmployeeConditionDto> conditionDtos = this.condition.matchLeaveCondition(command.getIds());
        if (conditionDtos != null && conditionDtos.size() > 0) {
            throw new NotAllowedTenantException(String.format("\u804c\u5458(%s)\u5305\u62ec\u8d44\u683c\u8bc1\u3001\u7b49\u7ea7\u8bc1, \u8d44\u683c\u8bc1\u7533\u62a5\u901a\u8fc7\u6216\u7533\u62a5\u4e0d\u901a\u8fc7\u6216\u5df2\u64a4\u9500/\u7b49\u7ea7\u8bc1\u3010\u7533\u62a5\u901a\u8fc7\u3011\u6216\u3010\u7533\u62a5\u4e0d\u901a\u8fc7\u3011\u6216\u3010\u7533\u62a5\u4e2d\u4e14\u786e\u8ba4\u6210\u7ee9\u3011\u6216\u3010\u5df2\u64a4\u9500\u3011\uff0c\u624d\u80fd\u8fdb\u884c\u79bb\u804c", conditionDtos.stream().map(EmployeeConditionDto::getInfo).collect(Collectors.joining(", "))));
        }
        List<EmployeeConditionDto> attendSiteDtos = this.condition.matchForAttendSite(command.getIds());
        if (attendSiteDtos != null && attendSiteDtos.size() > 0) {
            throw new NotAllowedTenantException(attendSiteDtos.stream().map(EmployeeConditionDto::getInfo).collect(Collectors.joining(", ")));
        }
        OperatorValueType operator = OperatorValueType.create((String)operateId, (String)operateName);
        this.unitWork.executeTran(() -> {
            for (EmployeeEntity employee : employees) {
                employee.leave(command.getExpectedDate(), command.getNote(), operator);
                this.employeeRepository.save(employee);
            }
        });
    }

    @Override
    public CommonImportResponse dispatch(BatchLeaveEmployeeExcelCommand command) {
        command.validate();
        Optional organizationOptional = this.organizationRepository.findById(command.getOrganizationId());
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException("\u7ec4\u7ec7\u65e0\u6548!");
        }
        OrganizationEntity organization = (OrganizationEntity)((Object)organizationOptional.get());
        Collection<BatchLeaveEmployeeExcelCommand.EmployeeCommandItem> commandItems = command.getCommandItems();
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        if (currentUser == null) {
            throw new UnAuthorizedTenantException("\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
        boolean isMaster = currentUser.isMaster();
        boolean isDepartAdmin = currentUser.isDepartAdmin();
        if (!isMaster && !isDepartAdmin) {
            throw new UnAuthorizedTenantException("\u53ea\u6709\u7ec4\u7ec7\u7ba1\u7406\u5458\u6216\u90e8\u95e8\u7ba1\u7406\u5458\u6709\u6743\u9650\u64cd\u4f5c");
        }
        List<Object> myDeptEmployeeIdList = new ArrayList();
        if (!isMaster) {
            myDeptEmployeeIdList = this.tenantDbReader.getMyDeptEmployeeIdList(command.getTreeCodes());
        }
        int successCount = 0;
        int failedCount = 0;
        int totalCount = 0;
        String msg = "";
        List<String> idnums = commandItems.stream().map(ii -> ii.getDataItem().getIdNum()).collect(Collectors.toList());
        Collection<EmployeeEntity> employees = this.employeeRepository.getByIdNums(command.getOrganizationId(), idnums);
        Map employeeMap = employees.stream().collect(Collectors.toMap(EmployeeEntity::getSelectIdNum, Function.identity()));
        List<String> ids = employees.stream().map(EmployeeEntity::getId).collect(Collectors.toList());
        List<EmployeeConditionDto> conditionDtos = this.condition.matchLeaveCondition(ids);
        Map conditionMap = conditionDtos.stream().collect(Collectors.toMap(EmployeeConditionDto::getEmployeeId, Function.identity()));
        List<EmployeeConditionDto> attendSiteDtos = this.condition.matchForAttendSite(ids);
        Map attendSiteConditionMap = attendSiteDtos.stream().collect(Collectors.toMap(EmployeeConditionDto::getEmployeeId, Function.identity()));
        for (BatchLeaveEmployeeExcelCommand.EmployeeCommandItem commandItem : commandItems) {
            ++totalCount;
            EmployeeEntity entity = (EmployeeEntity)((Object)employeeMap.get(commandItem.getDataItem().getIdNum()));
            if (entity == null) {
                commandItem.getDataItem().setErrMsg("\u7528\u6237\u4e0d\u5b58\u5728");
                ++failedCount;
                continue;
            }
            if (entity.getId().equals(currentUser.getEmployeeId())) {
                commandItem.getDataItem().setErrMsg("\u4e0d\u5141\u8bb8\u4e3a\u81ea\u5df1\u529e\u7406\u79bb\u804c");
                ++failedCount;
                continue;
            }
            if (!isMaster && !myDeptEmployeeIdList.contains(entity.getId())) {
                commandItem.getDataItem().setErrMsg("\u8be5\u804c\u5458\u5c5e\u4e8e\u5176\u4ed6\u90e8\u95e8\uff0c\u65e0\u6743\u9650\u64cd\u4f5c\u79bb\u804c");
                ++failedCount;
                continue;
            }
            if (StrUtil.isNotEmpty((CharSequence)commandItem.getErrorResult())) {
                ++failedCount;
                continue;
            }
            if (EmploymentStatus.OffJob.equals((Object)entity.getStatus())) {
                commandItem.getDataItem().setErrMsg("\u8be5\u804c\u5458\u5df2\u7ecf\u5904\u4e8e\u79bb\u804c\u72b6\u6001");
                ++failedCount;
                continue;
            }
            EmployeeConditionDto conditionDto = (EmployeeConditionDto)conditionMap.get(entity.getId());
            if (conditionDto != null) {
                commandItem.getDataItem().setErrMsg("\u8be5\u804c\u5458\u5305\u62ec\u8d44\u683c\u8bc1\u3001\u7b49\u7ea7\u8bc1, \u8d44\u683c\u8bc1\u7533\u62a5\u901a\u8fc7\u6216\u7533\u62a5\u4e0d\u901a\u8fc7\u6216\u5df2\u64a4\u9500/\u7b49\u7ea7\u8bc1\u3010\u7533\u62a5\u901a\u8fc7\u3011\u6216\u3010\u7533\u62a5\u4e0d\u901a\u8fc7\u3011\u6216\u3010\u7533\u62a5\u4e2d\u4e14\u786e\u8ba4\u6210\u7ee9\u3011\u6216\u3010\u5df2\u64a4\u9500\u3011\uff0c\u624d\u80fd\u8fdb\u884c\u79bb\u804c");
                ++failedCount;
                continue;
            }
            conditionDto = (EmployeeConditionDto)attendSiteConditionMap.get(entity.getId());
            if (conditionDto != null) {
                commandItem.getDataItem().setErrMsg(conditionDto.getInfo());
                ++failedCount;
                continue;
            }
            try {
                this.unitWork.executeTran(() -> {
                    entity.leave(commandItem.getDataItem().getLeaveDate(), commandItem.getDataItem().getRemark(), OperatorValueType.create((String)currentUser.getId(), (String)currentUser.getName()));
                    this.employeeRepository.save(entity);
                });
                ++successCount;
            }
            catch (TenantExceptionAbstract e) {
                ++failedCount;
                String eMessage = e.getMessage();
                commandItem.getDataItem().setErrMsg(eMessage);
                this.unitWork.detach((IAggregate)entity);
            }
        }
        String importedDataId = this.compositeDataRepository.execute(organization, command);
        if (failedCount != 0) {
            msg = "\u90e8\u5206\u6570\u636e\u672a\u6210\u529f\u79bb\u804c";
        }
        if (successCount == commandItems.size()) {
            msg = "\u79bb\u804c\u6210\u529f";
        }
        CommonImportResponse commonImportResponse = CommonImportResponse.create((String)importedDataId, (int)totalCount, (int)successCount, (int)failedCount, (String)msg);
        return commonImportResponse;
    }

    @Override
    public void dispatch(BackEmployeeCommand command) {
        command.validate(this.tenantUserConfig);
        Collection<EmployeeEntity> employees = this.employeeRepository.getByIds(command.getOrganizationId(), Collections.singleton(command.getId()));
        if (CollectionUtils.isEmpty(employees)) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u8be5\u804c\u5458\u4fe1\u606f");
        }
        EmployeeEntity selectedEmployee = employees.stream().findFirst().get();
        if (selectedEmployee.getStatus() != EmploymentStatus.OffJob) {
            throw new NotAllowedTenantException("\u8be5\u804c\u5458\u5df2\u7ecf\u5728\u804c; \u65e0\u6cd5\u91cd\u590d\u590d\u804c");
        }
        Collection departments = this.departmentRepository.getByIds(command.getOrganizationId(), Collections.singleton(command.getDepartId()));
        if (CollectionUtils.isEmpty((Collection)(departments = (Collection)departments.stream().filter(ix -> !ix.isDeleted()).collect(Collectors.toList())))) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u8be5\u90e8\u95e8\u4fe1\u606f");
        }
        DepartmentEntity selectedDepart = (DepartmentEntity)((Object)departments.stream().findFirst().get());
        this.unitWork.executeTran(() -> {
            this.departmentRepository.clearDuplicatedEmployeeRelationByEmployeeIds(Collections.singleton(selectedEmployee.getId()));
            selectedEmployee.back(this.eventDispatcher, selectedDepart, command.getOccupationType(), command.getHiredDate(), command.getOperator(), false);
            this.employeeRepository.save(selectedEmployee);
        });
    }

    @Override
    public void dispatch(BatchAssignEmployeeSuperiorCommand command) {
        command.validate();
        Collection<String> ids = command.getComputedIds();
        Collection<EmployeeEntity> selectedEmployees = this.employeeRepository.getByIds(command.getOrganizationId(), ids);
        Collection notExistsEmployeeIds = ids.stream().filter(ii -> !selectedEmployees.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)notExistsEmployeeIds)) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u804c\u5458(%s)\u4fe1\u606f", (Object)notExistsEmployeeIds.stream().collect(Collectors.joining(",")));
        }
        this.unitWork.executeTran(() -> command.getItems().stream().forEach(item -> {
            String newSuperiorId = item.getNewSuperiorId();
            if (!StringUtils.hasLength((String)newSuperiorId)) {
                newSuperiorId = null;
            }
            this.employeeRepository.replaceSuperior(command.getOrganizationId(), item.getOriginalSuperiorId(), newSuperiorId);
        }));
    }

    private DepartmentEntity getAndValidateDepartment(OrganizationEntity organization, String id) {
        if (!StringUtils.hasLength((String)id)) {
            return null;
        }
        Collection<DepartmentEntity> departments = this.departmentRepository.getByIds(organization.getId(), Collections.singleton(id));
        if (CollectionUtils.isEmpty(departments)) {
            throw new NotFoundTenantException(String.format("\u90e8\u95e8(%s)\u4fe1\u606f\u65e0\u6548!", id));
        }
        return departments.stream().findFirst().get();
    }

    private Collection<DepartmentEntity> getAndValidateDepartments(OrganizationEntity organization, Collection<String> departIds) {
        if (departIds == null || departIds.size() == 0) {
            return null;
        }
        Collection<DepartmentEntity> departments = this.departmentRepository.getByIds(organization.getId(), departIds);
        if (CollectionUtils.isEmpty(departments) || departments.size() != departIds.size()) {
            throw new NotFoundTenantException(String.format("\u90e8\u95e8(%s)\u4fe1\u606f\u65e0\u6548!", departIds.stream().collect(Collectors.joining(", "))));
        }
        return departments;
    }
}

