package com.bcxin.tenant.apis.translates.impls;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.api.interfaces.commons.ImportedResponseItem;
import com.bcxin.tenant.apis.translates.CommonTranslate;
import com.bcxin.tenant.domain.entities.ImportDataItemEntity;
import com.bcxin.tenant.domain.snapshots.ContractImportedItemSnapshot;
import com.bcxin.tenant.domain.snapshots.DepartmentImportedItemSnapshot;
import com.bcxin.tenant.domain.snapshots.EmployeeImportedItemSnapshot;
import com.bcxin.tenant.domain.snapshots.EmployeeLeaveExcelItemSnapshot;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class CommonTranslateImpl implements CommonTranslate {
    private final JsonProvider jsonProvider;

    public CommonTranslateImpl(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    @Override
    public Collection<ImportedResponseItem> Translate2ImportDepartmentResponse(Collection<ImportDataItemEntity> dataItems) {
        Collection<ImportedResponseItem> data =
                dataItems.stream().map(ii -> {
                    DepartmentImportedItemSnapshot item = this.jsonProvider.toObject(DepartmentImportedItemSnapshot.class,ii.getData());
                    Map<String, Object> parameters = new HashMap<>();
                    parameters.put("paramName", item.getName());
                    parameters.put("paramParentTreeName", item.getParentTreeName());
                    parameters.put("paramDisplayOrder", item.getDisplayOrder());
                    parameters.put("paramPermissionType", item.getPermissionType());
                    parameters.put("result", getFormattedResult(ii.getResult()));

                    return ImportedResponseItem.create(item.getParamIndex(),
                            parameters, (ii.getResult()),ii.getStatus());
                }).collect(Collectors.toList());

        return data;
    }

    @Override
    public Collection<ImportedResponseItem> Translate2ImportEmployeeResponse(Collection<ImportDataItemEntity> dataItems) {
        Collection<ImportedResponseItem> data =
                dataItems.stream().map(ii -> {
                    Map<String, Object> parameters = new HashMap<>();
                    EmployeeImportedItemSnapshot dataItem = this.jsonProvider.toObject(EmployeeImportedItemSnapshot.class, ii.getData());

                    parameters.put("paramName", dataItem.getName());
                    parameters.put("paramTelephone", dataItem.getTelephone());
                    parameters.put("paramHiredDate", dataItem.getHiredDateText());
                    parameters.put("paramDepartTreeName", dataItem.getDepartTreeName());
                    parameters.put("paramOccupationType", dataItem.getOccupationTypeText());
                    parameters.put("paramPosition", dataItem.getPositionText());
                    parameters.put("paramCredentialType", dataItem.getCredentialTypeText());
                    parameters.put("paramCredentialNumber", dataItem.getCredentialNumber());

                    parameters.put("paramNation", dataItem.getNation());
                    parameters.put("paramEducation", dataItem.getEducation());
                    parameters.put("paramPoliticsStatus", dataItem.getPoliticsStatus());
                    parameters.put("paramMilitaryStatus", dataItem.getMilitaryStatus());
                    parameters.put("paramMaritalStatus", dataItem.getMaritalStatus());
                    parameters.put("paramEmergencyContact", dataItem.getEmergencyContact());
                    parameters.put("paramEmergencyPhone", dataItem.getEmergencyPhone());
                    parameters.put("paramAddress", dataItem.getAddress());
                    parameters.put("paramHouseholdType", dataItem.getHouseholdType());

                    parameters.put("result", getFormattedResult(ii.getResult()));

                    return ImportedResponseItem.create(dataItem.getParamIndex(),
                            parameters, (ii.getResult()),ii.getStatus());
                }).collect(Collectors.toList());

        return data;
    }

    @Override
    public Collection<ImportedResponseItem> Translate2ImportContractResponse(Collection<ImportDataItemEntity> dataItems) {
        Collection<ImportedResponseItem> data =
                dataItems.stream().map(ii -> {
                    Map<String, Object> parameters = new HashMap<>();
                    ContractImportedItemSnapshot dataItem = this.jsonProvider.toObject(ContractImportedItemSnapshot.class, ii.getData());

                    parameters.put("paramName", dataItem.getName());
                    parameters.put("paramAName", dataItem.getAName());
                    parameters.put("paramBName", dataItem.getBName());
                    parameters.put("paramIdNum", dataItem.getIdNum());
                    parameters.put("paramBeginDate", dataItem.getBeginDateText());
                    parameters.put("paramEndDate", dataItem.getEndDateText());

                    parameters.put("result", getFormattedResult(ii.getResult()));

                    return ImportedResponseItem.create(dataItem.getParamIndex(),
                            parameters, (ii.getResult()), ii.getStatus());
                }).collect(Collectors.toList());

        return data;
    }

    @Override
    public Collection<ImportedResponseItem> Translate2LeaveEmployeeResponse(Collection<ImportDataItemEntity> dataItems) {
        Collection<ImportedResponseItem> data =
                dataItems.stream().filter(ii -> StrUtil.isNotEmpty(ii.getResult())).map(ii -> {
                    Map<String, Object> parameters = new HashMap<>();
                    EmployeeLeaveExcelItemSnapshot dataItem = this.jsonProvider.toObject(EmployeeLeaveExcelItemSnapshot.class, ii.getData());

                    parameters.put("username", dataItem.getName());
                    parameters.put("idNum", dataItem.getIdNum());
                    parameters.put("leaveDate", dataItem.getLeaveDateText());
                    parameters.put("remark", dataItem.getRemark());
                    parameters.put("errMsg", ii.getResult());
                    return ImportedResponseItem.create(dataItem.getParamIndex(),
                            parameters, (ii.getResult()), ii.getStatus());
                }).collect(Collectors.toList());

        return data;
    }

    private String getFormattedResult(String result) {
        if (!StringUtils.hasLength(result)) {
            return result;
        }

        if (result.toLowerCase(Locale.ROOT).contains("exception")) {
            return "网络异常, 请下载失败文件进行重新导入!";
        }

        return result;
    }
}
