package com.bcxin.tenant.apis.impls;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.backends.QueueRpcProvider;
import com.bcxin.api.interfaces.backends.requests.XlcpResultRequest;
import com.bcxin.api.interfaces.tenants.TenantXlcpRpcProvider;
import com.bcxin.tenant.domain.configs.SSOConfig;
import com.bcxin.tenant.domain.dto.XlcpReportDto;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.services.XlcpService;
import com.bcxin.tenant.domain.services.commands.xlcp.UpdateXlcpCommand;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

/**
 * <b> 心理测评业务 </b>
 * @author ZXF
 * @create 2025/03/17 0017 17:41
 * @version
 * @注意事项 </b>
 */
@Slf4j
@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0,
        /**
         * todo: 雪峰; 我调整异步的方式, 待雪峰验证.
        */
        methods = {
                @Method(name = "saveXlcp",retries = 0,timeout = 10 *1000)
        }
)
public class TenantXlcpRpcProviderImpl implements TenantXlcpRpcProvider {

    @Value("${bjxlcp1.uploadPath:}")
    public String uploadPath;
    @Value("${bjxlcp1.fileApi:}")
    public String fileApi;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final XlcpService xlcpService;
    private final TenantDbReader dbReader;

    private final QueueRpcProvider queueRpcProvider;

    private final CloseableHttpClient httpclient;
    public TenantXlcpRpcProviderImpl(XlcpService xlcpService,TenantDbReader dbReader,ThreadPoolTaskExecutor taskExecutor,QueueRpcProvider queueRpcProvider,CloseableHttpClient httpclient) {
        this.xlcpService = xlcpService;
        this.dbReader = dbReader;
        this.taskExecutor = taskExecutor;
        this.queueRpcProvider = queueRpcProvider;
        this.httpclient = httpclient;
    }

    @Override
    public void saveXlcp(String serialNumber,
                         String employeeId, String organizationId,
                         String projectName, String fileUrl, String suggestion,
                         String content, String result,String resultRuleTip,String randomKey) throws Exception {
        if (!SSOConfig.getUseSwitch()) {
            throw new Exception("登录失败:非授权使用环境！");
        }

        if (!SSOConfig.getSelfAuth()) {
            queueRpcProvider.dispatch(XlcpResultRequest.create(serialNumber, "", "", employeeId, organizationId, projectName, fileUrl, suggestion, content, result, resultRuleTip, uploadPath, fileApi,randomKey));
        }
    }

    /**
     * TODO 1, 改为使用httpClient对象, 复用连接；2, 目前业务个别文件转存返回的obs地址打开pdf文件内容是空白的需要优化
     *
     * @param path 本地暂存目录
     * @param fileApi 公共服务上传文件到obs接口地址
     * @param fileUrl 第三方文件访问地址
     * @return
     */
    private String getFileUrl(String path,String fileApi, String fileUrl) {
        String destFileName = Paths.get(path, UUID.randomUUID() + ".pdf").toString();
        File destFile = new File(destFileName);

        FileUtil.mkdir(destFile.getParentFile());
        try {
            if (!destFile.createNewFile()) {
                throw new BadTenantException("文件创建失败");
            }
            HttpGet httpGet = new HttpGet(fileUrl);
            HttpResponse response = httpclient.execute(httpGet);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new BadTenantException("远程文件获取失败");
            }
            // 下载远程文件到本地临时路径
            try (InputStream inputStream = entity.getContent()) {
                File file = FileUtil.writeFromStream(inputStream, destFile);
                if (file == null) {
                    throw new Exception("下载来源文件失败");
                }
                if (!isValidPdfFile(file)) {
                    throw new Exception("下载来源文件失败：内容为空");
                }

                Map<String, Object> map = Maps.newHashMap();
                map.put("xfile", destFile);

                // 使用hutool的HTTP请求工具模拟表单上传
                String uploadResult = HttpUtil.post(fileApi, map);
                JSONObject jsonObject = JSON.parseObject(uploadResult);

                if (!Objects.equals(jsonObject.getString("retType"), "0")) {
                    throw new Exception("文件上传失败：" + jsonObject.getString("msg"));
                }

                log.info("=========> 原测评结果文件地址: "+fileUrl+"，转换后地址："+jsonObject.getString("data"));
                //obs下载地址
                return jsonObject.getString("data");

            } catch (IOException e) {
                throw new Exception("文件下载过程中发生IO异常", e);
            }
        } catch (Exception e) {
            log.error("文件处理失败: {}", fileUrl, e);
            throw new BadTenantException("文件创建失败："+e.getMessage(), e);
        } finally {
            // 删除临时文件
            FileUtil.del(destFile);
        }
    }

    /**
     * 验证文件是否为有效的PDF文件
     * @param file 待验证的文件
     * @return 是否为有效的PDF文件
     */
    private static boolean isValidPdfFile(File file) {
        try {
            byte[] header = new byte[4];
            try (InputStream is = FileUtil.getInputStream(file)) {
                if (is.read(header) == 4) {
                    // PDF文件头部应该是 %PDF
                    return header[0] == 0x25 && header[1] == 0x50 &&
                            header[2] == 0x44 && header[3] == 0x46;
                }
            }
        } catch (IOException e) {
            log.warn("验证PDF文件时发生异常: {}", e.getMessage());
        }
        return false;
    }

    @Override
    public void updateXlcp(String employeeId, String organizationId, String fileUrl, String suggestion, String content, Integer status) throws Exception {
        this.xlcpService.dispatch(UpdateXlcpCommand.create(employeeId, organizationId, fileUrl, suggestion, content, status));
    }

    @Override
    public void updateXlcpFile(int day) {
        Collection<XlcpReportDto> list = this.xlcpService.findByThirdPath(day);
        for (XlcpReportDto dto : list){
            this.taskExecutor.execute(() -> {
                this.xlcpService.dispatch(dto.getNumber(),getFileUrl(uploadPath, fileApi, dto.getFileUrl()));
            });
        }
    }

}
