package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.RegionRpcProvider;
import com.bcxin.api.interfaces.commons.responses.RegionResponse;
import com.bcxin.api.interfaces.commons.responses.RegionTreeResponse;
import com.bcxin.tenant.domain.entities.RegionEntity;
import com.bcxin.tenant.domain.repositories.RegionRepository;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author linqinglin
 * @date 2021/12/08 0008 11:29
 */

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class RegionRpcProviderImpl implements RegionRpcProvider {


    private final RegionRepository regionRepository;
    private final RedisUtil redisUtil;

    public RegionRpcProviderImpl(RegionRepository regionRepository,
                                 RedisUtil redisUtil){
        this.regionRepository = regionRepository;
        this.redisUtil = redisUtil;
    }

    @Override
    public List<RegionResponse> findByParentId(String parentId) {
        if(StringUtils.isEmpty(parentId)){
            parentId = "100000";
        }

        List<RegionResponse> list = new ArrayList<>();
        Collection<RegionEntity> regionList=  regionRepository.findByParentId(parentId);

        if(regionList.size() > 0) {
            RegionResponse regionResponse = null;
            for (RegionEntity regionEntity : regionList) {
                regionResponse = new RegionResponse();
                BeanUtils.copyProperties(regionEntity, regionResponse);
                list.add(regionResponse);
            }
        }

        return list;
    }

    @Override
    public List<RegionTreeResponse> findAll() {
        String key = "all-region";
        if(redisUtil.get(key) != null){
            return (List<RegionTreeResponse>)redisUtil.get(key);
        }else {
            Collection<RegionEntity> regionList = regionRepository.findAll();
            List<RegionTreeResponse> list = new ArrayList<>();
            List<RegionTreeResponse> resultList = new ArrayList<>();
            RegionTreeResponse regionTree = null;
            if (regionList.size() > 0) {
                for (RegionEntity regionEntity : regionList) {
                    regionTree = RegionTreeResponse.create(regionEntity.getId(), regionEntity.getRegionName(), regionEntity.getParentId());
                    list.add(regionTree);
                    if (regionEntity.getParentId().equals("100000")) {
                        resultList.add(regionTree);
                    }
                }
                Map<String, List<RegionTreeResponse>> treeMap = list.stream().collect(Collectors.groupingBy(RegionTreeResponse::getParentId));

                for (RegionTreeResponse treeResponse : list) {
                    if (treeMap.get(treeResponse.getValue()) != null) {
                        treeResponse.setChildren(treeMap.get(treeResponse.getValue()));
                    }
                }
                redisUtil.set(key, resultList, 10 * 60);
            }

            return resultList;
        }
    }
}
