package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.enums.InvitedStatus;
import com.bcxin.Infrastructures.enums.InvitedType;
import com.bcxin.Infrastructures.models.CredentialModel;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.identities.requests.InvitedToJoinQueuesRequest;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.InvitedToJoinQueuesRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.InvitedToJoinQueuesCriteria;
import com.bcxin.api.interfaces.tenants.requests.employees.EmployeeRequest;
import com.bcxin.api.interfaces.tenants.responses.InvitedToJoinQueuesGetResponse;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.dtos.InvitedToJoinQueuesDto;
import com.bcxin.tenant.domain.services.InvitedToJoinQueuesService;
import com.bcxin.tenant.domain.services.commands.InvitedToJoinQueuesCommand;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;


@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0, methods = {
        @Method(name = "create",retries = 0,timeout = 10 *1000)})
public class InvitedToJoinQueuesRpcProviderImpl implements InvitedToJoinQueuesRpcProvider {

    private final InvitedToJoinQueuesService invitedToJoinQueuesService;

    private final TenantDbReader dbReader;



    public InvitedToJoinQueuesRpcProviderImpl(InvitedToJoinQueuesService invitedToJoinQueuesService, TenantDbReader dbReader) {
        this.invitedToJoinQueuesService = invitedToJoinQueuesService;
        this.dbReader = dbReader;
    }

    @Override
    public void create(InvitedType invitedType,String inviteId, EmployeeRequest request) {
        invitedToJoinQueuesService.dispatch(InvitedToJoinQueuesCommand.create(request.getName(),
                request.getTelephone(), request.getCredential().getType(),
                request.getCredential().getNumber(),  invitedType,
                request.getDepartId(),inviteId, request.getOccupationType(), InvitedStatus.Pending, null, null));
    }

    @Override
    public Pageable<InvitedToJoinQueuesGetResponse> find(String organizationId, InvitedToJoinQueuesCriteria criteria) {
        com.bcxin.tenant.domain.readers.criterias.InvitedToJoinQueuesCriteria invitedToJoinQueuesCriteria =
                translate2EmployeeCriteria(criteria);
        Pageable<InvitedToJoinQueuesDto> InvitedToJoinQueuesDtoPageable =
                this.dbReader.findInvitedToJoinQueuesMember(organizationId, invitedToJoinQueuesCriteria);

        Pageable<InvitedToJoinQueuesGetResponse> data = Pageable.create(
                InvitedToJoinQueuesDtoPageable.getPageIndex(),
                InvitedToJoinQueuesDtoPageable.getPageSize(),
                InvitedToJoinQueuesDtoPageable.getTotalCount(),
                InvitedToJoinQueuesDtoPageable.getData()
                        .stream().map(ix -> InvitedToJoinQueuesGetResponse.create(
                        ix.getId(),
                        ix.getName(),
                        ix.getTelephone(), ix.getCredentialType(),
                        ix.getCredentialNumber(), ix.getInviter(),
                        ix.getInvitedType(), ix.getDepartmentName(),ix.getDepartmentId(),
                        ix.getOccupationType(), ix.getAttendanceSiteName(), ix.getInvitedStatus()))
                        .collect(Collectors.toList()));

        return data;
    }

    @Override
    public void dispatch(String organizationId, InvitedToJoinQueuesRequest request) {
        invitedToJoinQueuesService.update(request);
    }

    private com.bcxin.tenant.domain.readers.criterias.InvitedToJoinQueuesCriteria translate2EmployeeCriteria(
            InvitedToJoinQueuesCriteria criteria) {
        com.bcxin.tenant.domain.readers.criterias.InvitedToJoinQueuesCriteria invitedToJoinQueuesCriteria = com.bcxin.tenant.domain.readers.criterias.InvitedToJoinQueuesCriteria.create(criteria.getPageIndex(), criteria.getPageSize(),
                criteria.getKeyword(), criteria.getDepartIds(), criteria.getOccupationTypes());
        return invitedToJoinQueuesCriteria;
    }
}
