package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.EmployeeRecordRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeRecordCriteria;
import com.bcxin.api.interfaces.tenants.responses.EmployeeRecordResponse;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.dtos.EmployeeRecordDto;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class EmployeeRecordRpcProviderImpl implements EmployeeRecordRpcProvider {
    private final TenantDbReader dbReader;

    public EmployeeRecordRpcProviderImpl(TenantDbReader dbReader) {
        this.dbReader = dbReader;
    }

    @Override
    public Pageable<EmployeeRecordResponse> search(
            String organizationId, EmployeeRecordCriteria criteria) {
        Pageable<EmployeeRecordDto> recordDtoPageable =
                this.dbReader.searchEmployeeRecords(com.bcxin.tenant.domain.readers.criterias.EmployeeRecordCriteria.create(organizationId, criteria.getEmployeeId(),
                        criteria.getPageIndex(), criteria.getPageSize())
                );

        Collection<EmployeeRecordResponse> data
                = recordDtoPageable.getData().stream().map(ii -> {
            EmployeeRecordResponse item =
                    EmployeeRecordResponse.create(
                            ii.getTenantUserId(), ii.getName(), ii.getCredentialType(), ii.getCredentialNumber(),
                            ii.getOccupationType(), ii.getActionTime(), ii.getStatus(), ii.getActionNode(), ii.getOperatorName(),
                            ii.getOperatorTime());

            return item;
        }).collect(Collectors.toList());

        return Pageable.create(recordDtoPageable.getPageIndex(), recordDtoPageable.getPageSize(), recordDtoPageable.getTotalCount(), data);
    }
}
