package com.bcxin.tenant.apis.impls;

import com.alibaba.excel.EasyExcel;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.DepartAdminRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.ContractCriteria;
import com.bcxin.api.interfaces.tenants.criterias.DepartAdminCriteria;
import com.bcxin.api.interfaces.tenants.requests.BatchCreateDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.BatchDeleteDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.uploads.UpdateDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.responses.DepartAdminGetResponse;
import com.bcxin.api.interfaces.tenants.responses.DepartResponse;
import com.bcxin.tenant.domain.configs.PlatformUploadConfig;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.dtos.DepartAdminDto;
import com.bcxin.tenant.domain.readers.dtos.DepartDto;
import com.bcxin.tenant.domain.repositories.dtos.ContractExportDto;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentAdminExportDto;
import com.bcxin.tenant.domain.services.DepartAdminService;
import com.bcxin.tenant.domain.services.commands.BatchCreateDepartAdminCommand;
import com.bcxin.tenant.domain.services.commands.BatchDeleteDepartAdminCommand;
import com.bcxin.tenant.domain.services.commands.UpdateDepartAdminCommand;
import org.apache.dubbo.config.annotation.DubboService;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class DepartAdminRpcProviderImpl implements DepartAdminRpcProvider {

    private final DepartAdminService departAdminService;
    private final TenantDbReader dbReader;

    public DepartAdminRpcProviderImpl(DepartAdminService departAdminService,
                                      TenantDbReader dbReader) {
        this.departAdminService = departAdminService;
        this.dbReader = dbReader;
    }

    @Override
    public void batchCreate(String organizationId, BatchCreateDepartAdminRequest request) {
        BatchCreateDepartAdminCommand command = BatchCreateDepartAdminCommand.create(
                organizationId,
                request.getEmployeeIds(), request.getDepartIds());

        this.departAdminService.dispatch(command);
    }

    @Override
    public void update(String organizationId, UpdateDepartAdminRequest request) {
        UpdateDepartAdminCommand command = UpdateDepartAdminCommand.create(
                organizationId,
                request.getEmployeeId(), request.getDepartIds());

        this.departAdminService.dispatch(command);
    }

    @Override
    public void batchDelete(String organizationId, BatchDeleteDepartAdminRequest request) {
        BatchDeleteDepartAdminCommand command = BatchDeleteDepartAdminCommand.create(
                organizationId,
                request.getEmployeeIds());

        this.departAdminService.dispatch(command);
    }

    @Override
    public Pageable<DepartAdminGetResponse> search(DepartAdminCriteria criteria) {
        com.bcxin.tenant.domain.readers.criterias.DepartAdminCriteria departAdminCriteria
                = com.bcxin.tenant.domain.readers.criterias.DepartAdminCriteria.create(criteria.getPageIndex(),
                criteria.getPageSize(),
                criteria.getEmployeeId(),
                criteria.getDepartIds(),
                criteria.getAdminDepartIds(),
                criteria.getKeyword());

        Pageable<DepartAdminDto> departAdminDtoPageable = this.dbReader.findDepartAdmins(criteria.getOrganizationId(), departAdminCriteria);

        Collection<DepartAdminGetResponse> departAdminGetResponses =
                departAdminDtoPageable.getData().stream().map(ii ->
                                DepartAdminGetResponse.create(ii.getEmployeeId(), ii.getName(), ii.getTelephone(), ii.getDepartName(), ii.getManagedDepartNames()))
                        .collect(Collectors.toList());

        return Pageable.create(
                departAdminDtoPageable.getPageIndex(), departAdminCriteria.getPageSize(),
                departAdminDtoPageable.getTotalCount(),
                departAdminGetResponses);
    }

    @Override
    public List<DepartResponse> getByEmployeeId(String employeeId) {
        List<DepartDto> departDtos = this.dbReader.findDepartAdminsByEmployeeId(employeeId);
        return departDtos.stream().map(ii ->
                DepartResponse.create(ii.getDepartId(),ii.getDepartName())).collect(Collectors.toList());
    }

    @Override
    public String exportExcel(String organizationId,DepartAdminCriteria criteria) {
        com.bcxin.tenant.domain.readers.criterias.DepartAdminCriteria departAdminCriteria
                = com.bcxin.tenant.domain.readers.criterias.DepartAdminCriteria.create(
                        criteria.getPageIndex(),
                criteria.getPageSize(),
                criteria.getEmployeeId(),
                criteria.getDepartIds(),
                criteria.getAdminDepartIds(),
                criteria.getKeyword());

        List<DepartmentAdminExportDto> list = this.dbReader.findExportDepartAdmins(organizationId, departAdminCriteria);
        String path = PlatformUploadConfig.getDownloadPath()+"部门管理员数据"+ Math.random()+".xlsx";
        File file = new File(path);
        if(!file.getParentFile().exists()){
            file.mkdirs();
        }
        EasyExcel.write(path, DepartmentAdminExportDto.class).sheet().doWrite(list);
        return path;
    }
}
