package com.bcxin.tenant.apis.eventHandlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.tenant.domain.events.TenantUserCreatedEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;



@Slf4j
@Component
public class TenantUserCreatedEvent_IdentityEventHandler extends DomainEventHandlerAbstract<TenantUserCreatedEvent> {
    private final IdentityRpcProvider identityRpcProvider;
    private final ThreadPoolTaskExecutor taskExecutor;

    public TenantUserCreatedEvent_IdentityEventHandler(IdentityRpcProvider identityRpcProvider,
                                                       ThreadPoolTaskExecutor taskExecutor) {
        this.identityRpcProvider = identityRpcProvider;
        this.taskExecutor = taskExecutor;
    }

    /**
     * 异步调用认证中心实现租户认证信息的同步
     * 添加认证信息失败的话.
     * 由定时后台任务进行失败补偿
     *
     * @param event
     */
    @Override
    protected void execute(TenantUserCreatedEvent event) {
        // 异步操作, 可不保证这个事件的执行, 后台任务将进行补偿处理
        // 新线程来处理这个事件
        /*,tenantUser.getSelectedCredential().getNumber(), tenantUser.getName(),
                        Collections.emptyList()
                );
                this.identityRpcProvider.signUp(request);
            });
        } catch (Exception ex) {
            log.error(String.format("【可忽略异常】TenantUserCreatedEvent_IdentityEventHandler.execute:%s", event.getData().getTelephone()), ex);
        }

         */
    }
}
