package com.bcxin.tenant.apis.eventHandlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.tenant.domain.events.OrganizationApprovedChangedEvent;
import com.bcxin.tenant.domain.v5.services.TDomainService;
import com.bcxin.tenant.domain.v5.services.commands.ApprovedDomainCommand;
import org.springframework.stereotype.Component;

/**
 * 企业审批通过之后, 订阅状态变更来更改企业应用包
 */
@Component
public class OrganizationApprovedChangedEvent_V5DomainPackageHandler extends DomainEventHandlerAbstract<OrganizationApprovedChangedEvent> {
    private final TDomainService domainService;

    public OrganizationApprovedChangedEvent_V5DomainPackageHandler(TDomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    protected void execute(OrganizationApprovedChangedEvent event) {
        if (event.getStatus() == ApprovedStatus.Passed) {
            this.domainService.dispatch(ApprovedDomainCommand.create(event.getOrganId(), event.getPlaceOfRegister(), event.getPlaceOfBusiness(),
                    event.getStatus(), event.getInstitutionalCode(),event.getSuperviseRegionCode())
            );
        }
    }
}
