package com.bcxin.tenant.apis.eventHandlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.events.EmployeeUpdatedEvent;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.UpdateUserCommand;
import org.springframework.stereotype.Component;

@Component
public class EmployeeUpdatedEvent_V5TUserEventHandler extends DomainEventHandlerAbstract<EmployeeUpdatedEvent> {
    private final TUserService userService;

    public EmployeeUpdatedEvent_V5TUserEventHandler(TUserService userService) {
        this.userService = userService;
    }

    @Override
    protected void execute(EmployeeUpdatedEvent event) {
        this.userService.dispatch(UpdateUserCommand.create(event.getData()));
    }
}
