package com.bcxin.tenant.apis;

import com.bcxin.Infrastructures.InitConfig;
import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.backends.BackendRpfProvider;
import com.bcxin.api.interfaces.backends.QueueRpcProvider;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.commons.PlatformOperateLogRpcProvider;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.rbacs.RbacCategoryRpcProvider;
import com.bcxin.api.interfaces.security.AttendSitePersonRpcProvider;
import com.bcxin.registration.nacos.NacosDataSourceConfig;
import com.bcxin.tenant.domain.TenantDomainConfig;
import com.bcxin.tenant.domain.repository.TenantConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(NacosDataSourceConfig.class)
@Configuration
@EnableDubbo(scanBasePackages = {"com.bcxin.tenant.apis.impls"})
@ComponentScan({
        "com.bcxin.api.interfaces.identities","com.bcxin.api.interfaces.rbacs",
        "com.bcxin.api.interfaces.buses",
        "com.bcxin.api.interfaces.tenants",
        "com.bcxin.api.interfaces.backends",
        "com.bcxin.Infrastructure.messages"
})
@Import({TenantDomainConfig.class, TenantConfig.class, InitConfig.class})
public class StartupConfig {
    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final IdentityRpcProvider identityRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final RbacCategoryRpcProvider rbacCategoryRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final MessageRpcProvider messageRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final BackendRpfProvider backendRpfProvider;
    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final QueueRpcProvider queueRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private AttendSitePersonRpcProvider attendSitePersonRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final PlatformOperateLogRpcProvider platformOperateLogRpcProvider;

    public StartupConfig(IdentityRpcProvider identityRpcProvider,
                         RbacCategoryRpcProvider rbacCategoryRpcProvider,
                         MessageRpcProvider messageRpcProvider,
                         BackendRpfProvider backendRpfProvider,
                         AttendSitePersonRpcProvider attendSitePersonRpcProvider,
                         QueueRpcProvider queueRpcProvider,
                         PlatformOperateLogRpcProvider platformOperateLogRpcProvider) {
        this.identityRpcProvider = identityRpcProvider;
        this.rbacCategoryRpcProvider = rbacCategoryRpcProvider;
        this.messageRpcProvider = messageRpcProvider;
        this.backendRpfProvider = backendRpfProvider;
        this.attendSitePersonRpcProvider = attendSitePersonRpcProvider;
        this.queueRpcProvider = queueRpcProvider;
        this.platformOperateLogRpcProvider = platformOperateLogRpcProvider;
    }

    @Bean
    public CloseableHttpClient httpClient() {
        CloseableHttpClient httpclient;
        // 创建连接池管理器
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        // 设置最大连接数
        connManager.setMaxTotal(500); // 总连接数
        connManager.setDefaultMaxPerRoute(80); // 每个路由的最大连接数
        // 设置请求配置
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(10000) // 连接超时时间（毫秒）
                .setSocketTimeout(10000) // 读取超时时间（毫秒）
                .build();
        // 创建 HttpClient 实例
        httpclient = HttpClients.custom()
                .setConnectionManager(connManager)
                .setDefaultRequestConfig(requestConfig)
                .build();

        return httpclient;
    }
}
