/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.tenants.responses.ResponseCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class AjaxPageResponse<T extends Serializable>
implements Serializable,
Cloneable {
    private String code;
    private String message;
    private Collection<T> data;
    private int pageNumber = 1;
    private int pageSize = 20;
    private long total = 0L;
    private long totalPage = 0L;
    private boolean pagination = true;
    private String sort;
    private String order;

    public AjaxPageResponse() {
        this(ResponseCode.SUCCESS, "\u64cd\u4f5c\u6210\u529f");
    }

    public AjaxPageResponse(String code) {
        this(code, null);
    }

    public AjaxPageResponse(String code, String message) {
        this.code = code == null ? ResponseCode.SUCCESS : code;
        this.message = message;
        if (this.message == null) {
            if (code.equals(ResponseCode.SUCCESS)) {
                this.message = "\u64cd\u4f5c\u6210\u529f";
            }
            if (code.equals(ResponseCode.FAIL)) {
                this.message = "\u64cd\u4f5c\u5931\u8d25";
            }
            if (code.equals(ResponseCode.UNAUTHORIZED)) {
                this.message = "\u7528\u6237\u9a8c\u8bc1\u5931\u8d25";
            }
        }
        this.data = new ArrayList<T>();
    }

    public static AjaxPageResponse fail() {
        return AjaxPageResponse.fail(null);
    }

    public static AjaxPageResponse fail(String message) {
        return new AjaxPageResponse(ResponseCode.FAIL, message);
    }

    public static AjaxPageResponse success() {
        return AjaxPageResponse.success(null);
    }

    public static AjaxPageResponse success(String message) {
        return new AjaxPageResponse(ResponseCode.SUCCESS, message);
    }

    public void setTotal(long total) {
        this.total = total;
        this.totalPage = this.total / (long)this.getPageSize();
        if (this.total % (long)this.getPageSize() != 0L) {
            ++this.totalPage;
        }
    }

    public AjaxPageResponse clone() throws CloneNotSupportedException {
        return (AjaxPageResponse)super.clone();
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Collection<T> getData() {
        return this.data;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public boolean isPagination() {
        return this.pagination;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public void setPagination(boolean pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AjaxPageResponse)) {
            return false;
        }
        AjaxPageResponse other = (AjaxPageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.isPagination() != other.isPagination()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Collection<T> this$data = this.getData();
        Collection<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !this$order.equals(other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AjaxPageResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNumber();
        result = result * 59 + this.getPageSize();
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $totalPage = this.getTotalPage();
        result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
        result = result * 59 + (this.isPagination() ? 79 : 97);
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Collection<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        return result;
    }

    public String toString() {
        return "AjaxPageResponse(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", totalPage=" + this.getTotalPage() + ", pagination=" + this.isPagination() + ", sort=" + this.getSort() + ", order=" + this.getOrder() + ")";
    }
}

