/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.stereotype.Component;

public interface FileValidator {
    public void execute(File var1);

    @Component
    public static class FileValidatorImpl
    implements FileValidator {
        private static final Collection<String> notAllowedFileExtenions = new ArrayList<String>();

        @Override
        public void execute(File file) {
            if (notAllowedFileExtenions.stream().anyMatch(ix -> file.getName().endsWith((String)ix))) {
                throw new NotAllowedTenantException("\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f");
            }
        }

        static {
            notAllowedFileExtenions.add(".sh");
            notAllowedFileExtenions.add(".jsp");
            notAllowedFileExtenions.add(".asp");
            notAllowedFileExtenions.add(".php");
            notAllowedFileExtenions.add(".bat");
            notAllowedFileExtenions.add(".js");
        }
    }
}

