/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.enums.PrincipalStatus;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="identity_principals")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class PrincipalAbstract
extends EntityAbstract {
    @Id
    @Column(name="id", length=100)
    private String id;
    @Column(name="last_updated_time", nullable=true)
    private Timestamp lastUpdatedTime;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="last_login_time", nullable=true)
    private Timestamp lastLoginTime;
    @Column(nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private PrincipalStatus status;
    @Column(name="last_status_changed_time")
    private Timestamp lastStatusChangedTime;
    @ManyToOne
    @JoinColumn(name="identity_user_id", referencedColumnName="id", nullable=false)
    private IdentityUserEntity identityUser;

    protected PrincipalAbstract() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setStatus(PrincipalStatus.INACTIVATE);
    }

    public void recordLastLoginTime() {
        this.setLastLoginTime(Timestamp.from(Instant.now()));
    }

    public String getId() {
        return this.id;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastLoginTime() {
        return this.lastLoginTime;
    }

    public PrincipalStatus getStatus() {
        return this.status;
    }

    public Timestamp getLastStatusChangedTime() {
        return this.lastStatusChangedTime;
    }

    public IdentityUserEntity getIdentityUser() {
        return this.identityUser;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastLoginTime(Timestamp lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    protected void setStatus(PrincipalStatus status) {
        this.status = status;
    }

    protected void setLastStatusChangedTime(Timestamp lastStatusChangedTime) {
        this.lastStatusChangedTime = lastStatusChangedTime;
    }

    protected void setIdentityUser(IdentityUserEntity identityUser) {
        this.identityUser = identityUser;
    }
}

