package com.bcxin.autodownloadupload.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description: 推送文件上传确认日志表
 * author: linchunpeng
 * date:  2023-04-21 10:05
 */
@Data
@TableName("push_record_upload_log")
public class PushRecordUploadLog {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //请求id
    private String requestId;

    //推送记录id
    private Long pushRecordId;

    //txt文件路径
    private String fileName;

    //文件链接
    private String fileUrl;

    //访问文件链接
    private String visitFileUrl;

    //访问结果，0-失败，1-成功
    private Boolean visitResult;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

}
