package com.bcxin.autodownloadupload.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description: 拉取记录表
 * author: linchunpeng
 * date:  2023-04-21 10:05
 */
@Data
@TableName("pull_record")
public class PullRecord {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //api地址
    private String requestApi;

    //请求id
    private String requestId;

    //区域代码
    private String regionCode;

    //拉取开始时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startTime;

    //拉取结束时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;

    //拉取表格列表
    private String tables;

    //是否去重：0-否，1-是
    private Boolean removeRepeat;

    //拉取类型：0-定时任务拉取，1-手动拉取，2-自动摆渡拉取
    private Integer pullType;

    //完整zip存储路径
    private String completeZipPath;

    //拉取结果信息
    private String pullResultInfo;

    //拉取错误信息
    private String pullErrorInfo;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

}
