/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.utils;

import com.bcxin.identity.domains.utils.Digests;
import com.bcxin.identity.domains.utils.Encodes;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    public static byte[] encPub = Base64.decode((String)"MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAESic24soUECzuSh2aYH0e+hQYh+/I01NmfjOnm5mwyUEYQvNCPTzn3BlNyufgMV+DWLUKV+2h0+PVel9jYTfG8Q==");
    public static byte[] encPriv = Base64.decode((String)"MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQg0dYU+I6IdiSe8bvWlsHuWfsjSn3XFZqOGWO3K1814O6gCgYIKoEcz1UBgi2hRANCAARKJzbiyhQQLO5KHZpgfR76FBiH78jTU2Z+M6ebmbDJQRhC80I9POfcGU3K5+AxX4NYtQpX7aHT49V6X2NhN8bx");
    public static Logger logger = LoggerFactory.getLogger(PasswordUtils.class);
    private static volatile PublicKey _pub;

    public static Map<String, String> entryptPassword(String plainPassword) {
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hashPassword", Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
        map.put("salt", salt.toString());
        return map;
    }

    public static boolean validatePassword(String plainPassword, String password) {
        byte[] salt = Encodes.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
    }

    public static String initSign(String password) {
        try {
            KeyFactory keyFact = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
            Signature signature = Signature.getInstance("SM3withSm2", (Provider)new BouncyCastleProvider());
            PrivateKey priv = keyFact.generatePrivate(new PKCS8EncodedKeySpec(encPriv));
            signature.initSign(priv);
            signature.update(password.getBytes(StandardCharsets.UTF_8));
            byte[] signatureValue = signature.sign();
            return Hex.toHexString((byte[])signatureValue);
        }
        catch (Exception ex) {
            logger.error("\u56fd\u5bc6\u7b7e\u540d\u9519\u8bef\uff1a{}", (Object)ex.getMessage());
            return "";
        }
    }

    public static boolean initVerify(String password, String hexPass) {
        try {
            Signature signature = Signature.getInstance("SM3withSm2", (Provider)new BouncyCastleProvider());
            signature.initVerify(PasswordUtils.getPublicKey());
            signature.update(password.getBytes(StandardCharsets.UTF_8));
            boolean res = signature.verify(Hex.decode((String)hexPass));
            return res;
        }
        catch (Exception ex) {
            logger.error("\u56fd\u5bc6\u9a8c\u8bc1\u7b7e\u540d\u9519\u8bef\uff1a{}", (Object)ex.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (_pub != null) return _pub;
        Class<PublicKey> clazz = PublicKey.class;
        synchronized (PublicKey.class) {
            if (_pub != null) return _pub;
            KeyFactory keyFact = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
            _pub = keyFact.generatePublic(new X509EncodedKeySpec(encPub));
            // ** MonitorExit[var0] (shouldn't be in output)
            return _pub;
        }
    }
}

