/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.entities;

import com.bcxin.Infrastructures.IdWorker;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.identity.domains.components.PasswordEncoder;
import com.bcxin.identity.domains.entities.IdentityUserEventEntity;
import com.bcxin.identity.domains.entities.PrincipalAbstract;
import com.bcxin.identity.domains.entities.UserNamePasswordPrincipalEntity;
import com.bcxin.identity.domains.entities.WechatPrincipalEntity;
import com.bcxin.identity.domains.enums.AlgorithmType;
import com.bcxin.identity.domains.enums.EventAction;
import com.bcxin.identity.domains.events.IdentityUser_WechatBindEvent;
import com.bcxin.identity.domains.exceptions.IdentityNotFoundException;
import com.bcxin.identity.domains.snapshots.WeChatSnapShoot;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Table(name="identity_user")
@Entity
public class IdentityUserEntity
extends EntityAbstract
implements IAggregate {
    private static final Logger logger = LoggerFactory.getLogger(IdentityUserEntity.class);
    @Id
    @Column(length=100)
    private String id;
    @Column(name="name", length=30, nullable=false)
    private String name;
    @Column(name="telephone", length=50, nullable=false)
    private String telephone;
    @Column(name="idnum", length=50)
    private String idNum;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @OneToMany(mappedBy="identityUser", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private Collection<PrincipalAbstract> principals;
    @OneToMany(mappedBy="identityUser", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Collection<IdentityUserEventEntity> identityUserEvents;
    @Column(name="note", length=2000)
    private String note;
    @Column(name="we_chat_json")
    private String weChatJson;
    @Column(name="tenant_user_id", length=50)
    private String tenantUserId;

    public void addUsernamePasswordPrincipal(String username, String plainPassword, PasswordEncoder passwordEncoder) {
        Collection<PrincipalAbstract> principalAbstracts = this.getPrincipals();
        long principalId = ((IdWorker)TenantContext.getInstance().resolve(IdWorker.class)).nextId();
        AlgorithmType algorithmType = AlgorithmType.SM2;
        String password = passwordEncoder.encode(algorithmType, plainPassword);
        principalAbstracts.add(UserNamePasswordPrincipalEntity.create(this, String.valueOf(principalId), username, algorithmType, password));
        this.setPrincipals(principalAbstracts);
    }

    public void addWechatCgiBin(String openId, String unionId) {
        Collection<PrincipalAbstract> principalAbstracts = this.getPrincipals();
        long principalId = ((IdWorker)TenantContext.getInstance().resolve(IdWorker.class)).nextId();
        principalAbstracts.add(WechatPrincipalEntity.create(this, String.valueOf(principalId), openId, this.getName(), unionId));
        this.setPrincipals(principalAbstracts);
    }

    protected IdentityUserEntity() {
    }

    public static IdentityUserEntity create(String tenantUserId, String name, String telephone, String idNum) {
        IdentityUserEntity identityUser = new IdentityUserEntity();
        long id = ((IdWorker)TenantContext.getInstance().resolve(IdWorker.class)).nextId();
        identityUser.setId(String.valueOf(id));
        if (!StringUtils.isEmpty((CharSequence)name) && name.length() > 20) {
            logger.warn("\u975e\u9884\u671f\u7684\u59d3\u540d\u4fe1\u606f\u65e0\u6548:{}", (Object)name);
            name = name.substring(0, 20);
        }
        identityUser.setName(name);
        identityUser.setTelephone(telephone);
        identityUser.setIdNum(idNum);
        identityUser.setTenantUserId(tenantUserId);
        identityUser.setCreatedTime(Timestamp.from(Instant.now()));
        identityUser.setPrincipals(new ArrayList<PrincipalAbstract>());
        return identityUser;
    }

    public void changePassword(String userName, PasswordEncoder passwordEncoder, String oldPassword, String newPassword, String confirmPassword) {
        UserNamePasswordPrincipalEntity userNamePasswordPrincipal = this.getByUserName(userName);
        if (userNamePasswordPrincipal == null) {
            throw new IdentityNotFoundException();
        }
        userNamePasswordPrincipal.changePassword(passwordEncoder, oldPassword, newPassword, confirmPassword);
    }

    public void resetPassword(String userName, PasswordEncoder passwordEncoder, String newPassword, String confirmPassword, boolean isAdminReset) {
        Collection<PrincipalAbstract> principals = this.getPrincipals();
        if (principals == null) {
            throw new IdentityNotFoundException();
        }
        UserNamePasswordPrincipalEntity userNamePasswordPrincipal = this.getByUserName(userName);
        if (userNamePasswordPrincipal == null) {
            throw new IdentityNotFoundException();
        }
        userNamePasswordPrincipal.resetPassword(passwordEncoder, newPassword, confirmPassword, isAdminReset);
    }

    public void bindWechat(JsonProvider jsonProvider, String openId, String nicky, String unionId) {
        WechatPrincipalEntity selectedWechatPrincipal;
        Optional<PrincipalAbstract> principalOptional;
        ArrayList<PrincipalAbstract> principals = (ArrayList<PrincipalAbstract>)this.getPrincipals().stream().collect(Collectors.toList());
        if (principals == null) {
            principals = new ArrayList<PrincipalAbstract>();
        }
        if ((principalOptional = principals.stream().filter(ii -> ii instanceof WechatPrincipalEntity).findFirst()).isPresent()) {
            selectedWechatPrincipal = (WechatPrincipalEntity)principalOptional.get();
            if (!selectedWechatPrincipal.getOpenId().equals(openId)) {
                throw new NotAllowedTenantException("\u8be5\u8d26\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u5fae\u4fe1\u4fe1\u606f, \u6e05\u89e3\u7ed1\u540e\u91cd\u8bd5");
            }
            selectedWechatPrincipal.setOpenId(openId);
            selectedWechatPrincipal.setNicky(nicky);
            selectedWechatPrincipal.setUnionId(unionId);
        } else {
            selectedWechatPrincipal = WechatPrincipalEntity.create(this, openId, nicky, unionId);
            principals.add(selectedWechatPrincipal);
        }
        this.setPrincipals(principals);
        WeChatSnapShoot weChatSnapShoot = WeChatSnapShoot.create(unionId, nicky);
        this.setWeChatJson(jsonProvider.getJson((Object)weChatSnapShoot));
        this.recordUserEvent(EventAction.BIND_WECHAT, openId, selectedWechatPrincipal);
    }

    public void unbindWechat() {
        Collection principals = this.getPrincipals().stream().collect(Collectors.toList());
        if (principals == null || principals.size() == 0) {
            throw new NotAllowedTenantException("\u8be5\u8d26\u53f7\u672a\u7ed1\u5b9a\u5fae\u4fe1, \u65e0\u987b\u89e3\u7ed1\u64cd\u4f5c");
        }
        Optional<PrincipalAbstract> principalOptional = principals.stream().filter(ii -> ((Object)ii).getClass().isAssignableFrom(WechatPrincipalEntity.class)).findFirst();
        if (!principalOptional.isPresent()) {
            throw new NotAllowedTenantException("\u8be5\u8d26\u53f7\u672a\u7ed1\u5b9a\u5fae\u4fe1, \u65e0\u987b\u89e3\u7ed1\u64cd\u4f5c");
        }
        WechatPrincipalEntity wechatPrincipalEntity = (WechatPrincipalEntity)principalOptional.get();
        principals.remove((Object)wechatPrincipalEntity);
        this.setPrincipals(principals);
        this.recordUserEvent(EventAction.UNBIND_WECHAT, wechatPrincipalEntity.getOpenId(), null);
        this.setWeChatJson(null);
        this.recordEvent(IdentityUser_WechatBindEvent.create(this.getTenantUserId(), null, null));
    }

    public void change(String name, String telephone, String idNum, boolean requiredPhoneAsLoginName) {
        Optional<UserNamePasswordPrincipalEntity> userNamePasswordOptional;
        this.setName(name);
        this.setTelephone(telephone);
        this.setIdNum(idNum);
        Collection<PrincipalAbstract> principals = this.getPrincipals();
        if (principals == null) {
            principals = new ArrayList<PrincipalAbstract>();
        }
        if ((userNamePasswordOptional = principals.stream().filter(ii -> ii instanceof UserNamePasswordPrincipalEntity).map(ii -> (UserNamePasswordPrincipalEntity)((Object)ii)).findFirst()).isPresent()) {
            userNamePasswordOptional.get().changeUserName(requiredPhoneAsLoginName ? telephone : idNum);
        }
    }

    public <T> void recordUserEvent(EventAction eventAction, T data, PrincipalAbstract principal) {
    }

    public void changeNote(String note) {
        this.setNote(note);
    }

    private UserNamePasswordPrincipalEntity getByUserName(String userName) {
        Collection<PrincipalAbstract> principals = this.getPrincipals();
        if (principals == null) {
            throw new IdentityNotFoundException();
        }
        Optional<UserNamePasswordPrincipalEntity> userNamePasswordPrincipalOptional = principals.stream().filter(ii -> ii instanceof UserNamePasswordPrincipalEntity).map(ii -> (UserNamePasswordPrincipalEntity)((Object)ii)).filter(ii -> StringUtils.equalsIgnoreCase((CharSequence)ii.getUserName(), (CharSequence)userName)).findFirst();
        if (userNamePasswordPrincipalOptional.isPresent()) {
            return userNamePasswordPrincipalOptional.get();
        }
        return null;
    }

    public void changeUserName(String userName, PasswordEncoder passwordEncoder, String currentPassword) {
        Optional<UserNamePasswordPrincipalEntity> userNamePasswordPrincipalOptional = this.principals.stream().filter(ii -> ii instanceof UserNamePasswordPrincipalEntity).map(ii -> (UserNamePasswordPrincipalEntity)((Object)ii)).findFirst();
        if (!userNamePasswordPrincipalOptional.isPresent()) {
            throw new NotFoundTenantException();
        }
        UserNamePasswordPrincipalEntity userNamePasswordPrincipal = userNamePasswordPrincipalOptional.get();
        if (!passwordEncoder.isMatched(userNamePasswordPrincipal.getPassword(), currentPassword)) {
            throw new ForbidTenantException("\u539f\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        userNamePasswordPrincipal.changeUserName(userName);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getIdNum() {
        return this.idNum;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Collection<PrincipalAbstract> getPrincipals() {
        return this.principals;
    }

    public Collection<IdentityUserEventEntity> getIdentityUserEvents() {
        return this.identityUserEvents;
    }

    public String getNote() {
        return this.note;
    }

    public String getWeChatJson() {
        return this.weChatJson;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    protected void setIdNum(String idNum) {
        this.idNum = idNum;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setPrincipals(Collection<PrincipalAbstract> principals) {
        this.principals = principals;
    }

    protected void setIdentityUserEvents(Collection<IdentityUserEventEntity> identityUserEvents) {
        this.identityUserEvents = identityUserEvents;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setWeChatJson(String weChatJson) {
        this.weChatJson = weChatJson;
    }

    protected void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }
}

