package com.bcxin.tenant.apis.translates;

import com.bcxin.api.interfaces.commons.responses.CompanyResponse;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyUpdateRequest;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.services.commands.organizations.RegisterCompanyCommand;
import com.bcxin.tenant.domain.services.commands.organizations.UpdateCompanyCommand;

public interface OrganizationTranslate {

    /**
     * description: 数据转换
     * author: linchunpeng
     * date:  2023-05-09 13:55
     */
    RegisterCompanyCommand translate(CompanyRegistrationRequest request);

    UpdateCompanyCommand translate(CompanyUpdateRequest request);

    CompanyResponse translate(OrganizationEntity organizationEntity, CompanyResponse.ContactRequest admin);

}
