package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.enums.AbnormalPersonnelEmployeeType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.identities.requests.UserRegisterRequest;
import com.bcxin.api.interfaces.tenants.RegisterRpcProvider;
import com.bcxin.tenant.domain.configs.RegisterConfig;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.services.EmployeeService;
import com.bcxin.tenant.domain.services.commands.CreateEmployeeRequestCommand;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.SyncUserRoleCommand;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class RegisterRpcProviderImpl implements RegisterRpcProvider {

    private final EmployeeService employeeService;
    private final EmployeeRepository employeeRepository;

    private final TUserService tUserService;

    public RegisterRpcProviderImpl(EmployeeRepository employeeRepository,
                                         EmployeeService employeeService,
                                         TUserService tUserService){
        this.employeeRepository = employeeRepository;
        this.employeeService = employeeService;
        this.tUserService = tUserService;
    }

    @Override
    public void saveLoginUser(UserRegisterRequest request) {
        /*request.setPassword(RSAUtils.formatFrontPassword(true, request.getPassword()));
        request.setConfirmPassword(RSAUtils.formatFrontPassword(true, request.getConfirmPassword()));
        if(!request.getPassword().equals(request.getConfirmPassword())){
            throw new UnAuthorizedTenantException("密码与确认密码不一致！");
        }*/

        RegisterConfig.LegalConfig legalConfig = RegisterConfig.legalConfigMap.get(request.getAreaCode());
        if(legalConfig == null){
            throw new UnAuthorizedTenantException("该区域编码未配置！");
        }

        EmployeeEntity employee = employeeRepository.getByIdNum(legalConfig.getDomainId(), request.getIdNum());
        if(employee == null){
            String employeeId = this.employeeService.dispatch(
                    CreateEmployeeRequestCommand.create(legalConfig.getDomainId(),
                            request.getName(), request.getPhone(),
                            null,
                            legalConfig.getDepartId(), OccupationType.Normal, null,
                            new Date(), CredentialType.IdCard,
                            request.getIdNum(),
                            AuthUtil.getCurrentOperator(),
                            AbnormalPersonnelEmployeeType.NOT_VERIFY));
            List<String> roles = new ArrayList<>();
            roles.add(legalConfig.getRoleId());
            List<String> employeeIds = new ArrayList<>();
            employeeIds.add(employeeId);
            this.tUserService.dispatch(SyncUserRoleCommand.create(true, legalConfig.getDomainId(), employeeIds, roles));
        }else{
            throw new ConflictTenantException("该账号已经存在!");
        }

    }
}
