package com.bcxin.tenant.apis.impls;

import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.OrganizationStatisticsRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationStatisticsCreateRequest;

import com.bcxin.tenant.domain.services.OrganizationStatisticsService;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class OrganizationStatisticsRpcProviderImpl implements OrganizationStatisticsRpcProvider {
    private final OrganizationStatisticsService organizationStatisticsService;

    public OrganizationStatisticsRpcProviderImpl(OrganizationStatisticsService organizationStatisticsService) {
        this.organizationStatisticsService = organizationStatisticsService;
    }

    @Override
    public void createOrgStatisticsById(OrganizationStatisticsCreateRequest request) {
        organizationStatisticsService.createStatisticsById(request.getOrgIds());
    }

    @Override
    public void syncOrganizationStatistics() {
        organizationStatisticsService.syncOrganizationStatistics();
    }
}
