package com.bcxin.tenant.apis.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.StringUtils;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.ExternalGroupRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.externalGroups.ExternalGroupRequest;
import com.bcxin.api.interfaces.tenants.requests.externalGroups.ExternalGroupSearchRequest;
import com.bcxin.api.interfaces.tenants.responses.ExternalGroupResponse;
import com.bcxin.tenant.domain.repositories.ExternalGroupRepository;
import com.bcxin.tenant.domain.repositories.dtos.ExternalGroupDTO;
import com.bcxin.tenant.domain.services.ExternalGroupService;
import com.bcxin.tenant.domain.services.commands.externalGroups.CreateExternalGroupCommand;
import com.bcxin.tenant.domain.services.commands.externalGroups.DeleteExternalGroupCommand;
import com.bcxin.tenant.domain.services.commands.externalGroups.UpdateExternalGroupCommand;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0)
public class ExternalGroupRpcProviderImpl implements ExternalGroupRpcProvider {

    private final ExternalGroupService externalGroupService;
    private final ExternalGroupRepository externalGroupRepository;

    public ExternalGroupRpcProviderImpl(ExternalGroupService externalGroupService, ExternalGroupRepository externalGroupRepository) {
        this.externalGroupService = externalGroupService;
        this.externalGroupRepository = externalGroupRepository;
    }

    @Override
    public void create(ExternalGroupRequest request) {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if(userModel==null) {
            throw new UnAuthorizedTenantException("未认证用户");
        }

        this.externalGroupService.create(CreateExternalGroupCommand.create(
                ResourceReferenceType.Organization,
                userModel.getOrganId(),
                request.getParentId(),
                request.getName(),
                request.getPrincipalId(),
                request.getDisplayOrder()
        ));
    }

    @Override
    public void update(String id, ExternalGroupRequest request) {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if(userModel==null) {
            throw new UnAuthorizedTenantException("未认证用户");
        }

        this.externalGroupService.update(UpdateExternalGroupCommand.create(
                id,
                ResourceReferenceType.Organization,
                userModel.getOrganId(),
                request.getName(),
                request.getPrincipalId(),
                request.getParentId(),
                request.getDisplayOrder()
        ));
    }

    @Override
    public void delete(String id) {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException("未认证用户");
        }
        this.externalGroupService.delete(DeleteExternalGroupCommand.create(
                ResourceReferenceType.Organization,
                userModel.getOrganId(),
                id,
                userModel.getEmployeeId()
        ));
    }

    @Override
    public Collection<ExternalGroupResponse> search(ExternalGroupSearchRequest request) {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();

        Collection<ExternalGroupDTO> data =
                this.externalGroupRepository.getAll(userModel.getOrganId());

        Collection<ExternalGroupResponse> result = new HashSet<>();
        Collection<ExternalGroupDTO> roots =
                data.stream().filter(ii -> StringUtils.isEmpty(ii.getParentId()))
                        .collect(Collectors.toList());

        return roots.stream().map(ix -> build(ix, data)).collect(Collectors.toList());
    }

    private ExternalGroupResponse build(ExternalGroupDTO item,Collection<ExternalGroupDTO> data) {
        ExternalGroupResponse rs = ExternalGroupResponse.create(item.getId(), item.getName(), item.getTotalCount(), item.getDisplayOrder());

        data.stream()
                .filter(ii -> rs.getId().equalsIgnoreCase(ii.getParentId()))
                .sorted((ix, it) -> ix.getDisplayOrder() > it.getDisplayOrder() ? -1 : 1)
                .forEach(ix -> {
                    rs.assignChild(build(ix, data));
                });

        return rs;
    }
}
