package com.bcxin.tenant.apis.eventHandlers;

import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.ChangeBasicIdentityRequest;
import com.bcxin.tenant.domain.events.TenantUserTelephoneChangedEvent;
import com.bcxin.tenant.domain.v5.services.TUserService;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class TenantUserTelephoneChangedEvent_V5TUserHandler extends DomainEventHandlerAbstract<TenantUserTelephoneChangedEvent> {
    private final TUserService userService;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final RetryProvider retryProvider;

    public TenantUserTelephoneChangedEvent_V5TUserHandler(TUserService userService,
                                                          ThreadPoolTaskExecutor taskExecutor,
                                                          RetryProvider retryProvider) {
        this.userService = userService;
        this.taskExecutor = taskExecutor;
        this.retryProvider = retryProvider;
    }

    @Override
    protected void execute(TenantUserTelephoneChangedEvent event) {
        this.taskExecutor.execute(() -> {
            this.retryProvider.execute(() -> {
                this.userService.changeBasic(ChangeBasicIdentityRequest.create(event.getId(), event.getName(), null, event.getTelephone(),event.getOldPhone()));
            }, 10);
        });
    }
}
