/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import com.bcxin.api.interfaces.tenants.responses.UserProfileGetResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UserDetailGetResponse
extends UserProfileGetResponse {
    private final String email;
    private final String nicky;
    @ApiModelProperty(value="\u8bc1\u4ef6\u4fe1\u606f", required=true)
    private final CredentialInfo credential;

    public UserDetailGetResponse(String id, String name, String email, String nicky, String telephone, String lonLatJson, Date birthdate, UserCheckedStatus checkedStatus, RealNameAuthenticatedStatus authenticateStatus, String authenticatedResult, String stature, String headPhoto, Sex sex, String nation, Integer workYear, String diseasesHistory, String politicsStatus, String militaryStatus, String education, String householdType, String nativePlace, String maritalStatus, String oneInchColorWhitePhoto, String twoInchColorBluePhoto, String cid, String emergencyContact, String emergencyPhone, String licenseLevel, String thirdPartyLoginNo, String imIdentity, LocationRequest placeOfNow, CredentialInfo credential) {
        super(id, name, telephone, lonLatJson, birthdate, checkedStatus, authenticateStatus, authenticatedResult, stature, headPhoto, sex, nation, diseasesHistory, workYear, politicsStatus, militaryStatus, education, householdType, nativePlace, maritalStatus, oneInchColorWhitePhoto, twoInchColorBluePhoto, cid, emergencyContact, emergencyPhone, licenseLevel, thirdPartyLoginNo, imIdentity, placeOfNow, null, null, null);
        this.email = email;
        this.nicky = nicky;
        this.credential = credential;
    }

    public static UserDetailGetResponse create(String id, String name, String email, String nicky, String telephone, String lonLatJson, Date birthdate, UserCheckedStatus checkedStatus, RealNameAuthenticatedStatus authenticateStatus, String authenticatedResult, String stature, String headPhoto, Sex sex, String nation, Integer workYear, String diseasesHistory, String politicsStatus, String militaryStatus, String education, String householdType, String nativePlace, String maritalStatus, String oneInchColorWhitePhoto, String twoInchColorBluePhoto, String cid, String emergencyContact, String emergencyPhone, String licenseLevel, String thirdPartyLoginNo, String imIdentity, LocationRequest placeOfNow, CredentialInfo credential) {
        return new UserDetailGetResponse(id, name, email, nicky, telephone, lonLatJson, birthdate, checkedStatus, authenticateStatus, authenticatedResult, stature, headPhoto, sex, nation, workYear, diseasesHistory, politicsStatus, militaryStatus, education, householdType, nativePlace, maritalStatus, oneInchColorWhitePhoto, twoInchColorBluePhoto, cid, emergencyContact, emergencyPhone, licenseLevel, thirdPartyLoginNo, imIdentity, placeOfNow, credential);
    }

    public String getEmail() {
        return this.email;
    }

    public String getNicky() {
        return this.nicky;
    }

    public CredentialInfo getCredential() {
        return this.credential;
    }

    public static class CredentialInfo
    implements Serializable {
        @ApiModelProperty(value="\u8bc1\u4ef6\u7c7b\u578b")
        private final CredentialType credentialType;
        @ApiModelProperty(value="\u59d3\u540d")
        private final String name;
        @ApiModelProperty(value="\u4eba\u5934\u50cf")
        private final String headPhoto;
        @ApiModelProperty(value="\u8bc1\u4ef6\u53f7\u7801")
        private final String number;
        @ApiModelProperty(value="\u6709\u6548\u671f\u4ece")
        private final Date validDateFrom;
        @ApiModelProperty(value="\u6709\u6548\u671f\u4ece")
        private final Date validDateTo;
        @ApiModelProperty(value="\u8eab\u4efd\u8bc1\u4eba\u50cf\u9762")
        private final String frontPhoto;
        @ApiModelProperty(value="\u8eab\u4efd\u8bc1\u56fd\u5fbd\u9762")
        private final String reversePhoto;
        @ApiModelProperty(value="\u8eab\u4efd\u8bc1\u5730\u5740")
        private final String address;

        public String getValidRang() {
            if (this.validDateFrom == null) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (this.validDateTo == null) {
                return String.format("%s\u81f3\u6c38\u4e45", simpleDateFormat.format(this.getValidDateFrom()));
            }
            return String.format("%s\u81f3%s", simpleDateFormat.format(this.getValidDateFrom()), simpleDateFormat.format(this.getValidDateTo()));
        }

        public CredentialInfo(String name, String headPhoto, CredentialType credentialType, String number, Date validDateFrom, Date validDateTo, String frontPhoto, String reversePhoto, String address) {
            this.name = name;
            this.headPhoto = CdnUtils.convert((String)headPhoto);
            this.credentialType = credentialType;
            this.number = number;
            this.validDateFrom = validDateFrom;
            this.validDateTo = validDateTo;
            this.frontPhoto = CdnUtils.convert((String)frontPhoto);
            this.reversePhoto = CdnUtils.convert((String)reversePhoto);
            this.address = address;
        }

        public static CredentialInfo create(String name, String headPhoto, CredentialType credentialType, String number, Date validDateFrom, Date validDateTo, String frontPhoto, String reversePhoto, String address) {
            return new CredentialInfo(name, headPhoto, credentialType, number, validDateFrom, validDateTo, frontPhoto, reversePhoto, address);
        }

        public CredentialType getCredentialType() {
            return this.credentialType;
        }

        public String getName() {
            return this.name;
        }

        public String getHeadPhoto() {
            return this.headPhoto;
        }

        public String getNumber() {
            return this.number;
        }

        public Date getValidDateFrom() {
            return this.validDateFrom;
        }

        public Date getValidDateTo() {
            return this.validDateTo;
        }

        public String getFrontPhoto() {
            return this.frontPhoto;
        }

        public String getReversePhoto() {
            return this.reversePhoto;
        }

        public String getAddress() {
            return this.address;
        }
    }
}

