/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.rbacs.responses;

import com.bcxin.Infrastructures.entities.OperatorValueType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class ResourceGetResponse
implements Serializable {
    private final String id;
    private final String categoryId;
    private final String name;
    private final String data;
    private final String dataType;
    private final String metaId;
    private final String metaConfig;
    private final String metaData;
    private final OperatorValueType creator;
    private final OperatorValueType lastModifier;
    private boolean hasPermission = true;
    private final Collection<ResourceGetResponse> children = new ArrayList<ResourceGetResponse>();

    public ResourceGetResponse(String id, String categoryId, String name, String data, String dataType, String metaId, String metaConfig, String metaData, OperatorValueType creator, OperatorValueType lastModifier) {
        this.id = id;
        this.categoryId = categoryId;
        this.name = name;
        this.data = data;
        this.dataType = dataType;
        this.metaId = metaId;
        this.metaConfig = metaConfig;
        this.metaData = metaData;
        this.creator = creator;
        this.lastModifier = lastModifier;
    }

    public static ResourceGetResponse create(String id, String categoryId, String name, String data, String dataType, String metaId, String metaConfig, String metaData, OperatorValueType creator, OperatorValueType lastModifier) {
        return new ResourceGetResponse(id, categoryId, name, data, dataType, metaId, metaConfig, metaData, creator, lastModifier);
    }

    public void assignChildResource(ResourceGetResponse response) {
        this.getChildren().add(response);
    }

    public void assignPermissionStatus(boolean hasPermission) {
        this.hasPermission = hasPermission;
    }

    public boolean isShow() {
        if (this.hasPermission) {
            return true;
        }
        if (!CollectionUtils.isEmpty(this.getChildren())) {
            return this.getChildren().stream().anyMatch(ix -> ix.isShow());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public String getMetaConfig() {
        return this.metaConfig;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public OperatorValueType getCreator() {
        return this.creator;
    }

    public OperatorValueType getLastModifier() {
        return this.lastModifier;
    }

    public Collection<ResourceGetResponse> getChildren() {
        return this.children;
    }
}

