package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.Infrastructures.utils.CdnUtils;
import com.bcxin.api.interfaces.ResponseAbstract;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Date;

@ApiModel(description = "当前用户的基本信息")
@Getter
public class UserProfileGetResponse extends ResponseAbstract {
    /**
     * 租户的Id信息
     */
    @ApiModelProperty(value = "Id")
    private final String id;
    @ApiModelProperty(value = "姓名",required = true,example = "张三")
    private final String name;
    @ApiModelProperty(value = "经纬度坐标",example = "'{\"latitude\":24.607463,\"longitude\":118.052021,\"time\":\"2021-07-14 11:24:04\"}'",dataType = "String")
    private final String lonLatJson;

    @ApiModelProperty(value = "手机号码",dataType = "String")
    private final String telephone;

    @ApiModelProperty(value = "核验状态",example = "Matched",allowableValues = "None, Matched, NotMatched.")
    private final UserCheckedStatus checkedStatus;
    @ApiModelProperty(value = "实名认证状态",example = "Passed",allowableValues = "UnAuthenticated, Authenticating, Failed, Passed.")
    private final RealNameAuthenticatedStatus authenticateStatus;
    @ApiModelProperty(value = "实名认证备注",example = "实名认证结果一致通过")
    private final String authenticatedResult;

    @ApiModelProperty(value = "头像")
    private final String headPhoto;

    @ApiModelProperty(value = "性别")
    private final Sex sex;

    @ApiModelProperty(value = "民族")
    private final String nation;
    @ApiModelProperty(value = "疾病历史")
    private final String diseasesHistory;
    @ApiModelProperty(value = "从业年限")
    private final Integer workYear;
    @ApiModelProperty(value = "政治面貌")
    private final String politicsStatus;

    @ApiModelProperty(value = "身高",example = "180cm")
    private final String stature;

    @ApiModelProperty(value = "兵役情况")
    private final String militaryStatus;

    @ApiModelProperty(value = "出生日期",example = "1990-01-01",dataType = "String")
    private final Date birthdate;

    @ApiModelProperty(value = "文化程度")
    private final String education;

    @ApiModelProperty(value = "户籍类型")
    private final String householdType;

    @ApiModelProperty(value = "籍贯")
    private final String nativePlace;

    @ApiModelProperty(value = "婚姻状况")
    private final String maritalStatus;

    @ApiModelProperty(value = "一寸免冠白底彩照")
    private final String oneInchColorWhitePhoto;

    @ApiModelProperty(value = "两寸免冠蓝底彩照")
    private final String twoInchColorBluePhoto;

    @ApiModelProperty(value = "设备Id")
    private final String cid;

    /**
     * IM标识符
     * 一般采用id的方式, 但是对于旧数据，我们手机号码，但是手机号码又会发生变更，因此采用这个字段来进行表示
     */
    @ApiModelProperty(value = "IM标识符")
    private String imIdentity;

    /**
     * 紧急联系人
     */
    @ApiModelProperty(value = "紧急联系人")
    private final String emergencyContact;

    /**
     * 紧急联系人电话
     */
    @ApiModelProperty(value = "紧急联系人电话")
    private final String emergencyPhone;

    /**
     * 驾照等级
     */
    @ApiModelProperty(value = "驾照等级")
    private final String licenseLevel;

    /**
     * 现住地址
     */
    @ApiModelProperty(value = "现住地址")
    private final LocationRequest placeOfNow;

    /**
     * 第三方登录标识
     */
    @ApiModelProperty(value = "现住地址")
    private final String  thirdPartyLoginNo;

    @ApiModelProperty(value = "申诉状态",example = "None",allowableValues = "None, Passed, Failed, Request.")
    private final AppealStatus appealStatus;

    @ApiModelProperty(value = "最后一次申诉结果")
    private final String lastAppealResult;

    @ApiModelProperty(value = "最后一次申诉时间")
    private final Date lastAppealTime;

    public UserProfileGetResponse(
            String id, String name,
            String telephone,
            String lonLatJson,
            Date birthdate,
            UserCheckedStatus checkedStatus,
            RealNameAuthenticatedStatus authenticateStatus,
            String authenticatedResult,
            String stature,
            String headPhoto,
            Sex sex, String nation,
            String diseasesHistory, Integer workYear, String politicsStatus,
            String militaryStatus,
            String education,
            String householdType,
            String nativePlace,
            String maritalStatus,
            String oneInchColorWhitePhoto,
            String twoInchColorBluePhoto,
            String cid,
            String emergencyContact,
            String emergencyPhone,
            String licenseLevel,
            String thirdPartyLoginNo,
            String imIdentity,
            LocationRequest placeOfNow,
            AppealStatus appealStatus,
            String lastAppealResult,
            Date lastAppealTime) {
        this.id = id;
        this.name = name;
        this.lonLatJson = lonLatJson;
        this.telephone = telephone;
        this.birthdate = birthdate;
        this.checkedStatus = checkedStatus;
        this.authenticateStatus = authenticateStatus;
        this.authenticatedResult = authenticatedResult;
        this.stature = stature;
        this.headPhoto = CdnUtils.convert(headPhoto);
        this.appealStatus = appealStatus;
        this.lastAppealResult = lastAppealResult;
        this.lastAppealTime = lastAppealTime;
        if (sex != null && (sex.ordinal() == Sex.Male.ordinal() || sex.ordinal() == Sex.Female.ordinal())) {
            this.sex = sex;
        } else {
            this.sex = null;
        }
        this.nation = nation;
        this.diseasesHistory = diseasesHistory;
        this.workYear = workYear;
        this.politicsStatus = politicsStatus;
        this.militaryStatus = militaryStatus;
        this.education = education;
        this.householdType = householdType;
        this.nativePlace = nativePlace;
        this.maritalStatus = maritalStatus;
        this.oneInchColorWhitePhoto = CdnUtils.convert(oneInchColorWhitePhoto);
        this.twoInchColorBluePhoto = CdnUtils.convert(twoInchColorBluePhoto);
        this.cid = cid;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        this.placeOfNow = placeOfNow;
        this.thirdPartyLoginNo = thirdPartyLoginNo;
        this.imIdentity = imIdentity;
    }

    public static UserProfileGetResponse create(
            String id, String name,
            String telephone,
            String lonLatJson,
            Date birthdate,
            UserCheckedStatus checkedStatus,
            RealNameAuthenticatedStatus authenticateStatus,
            String authenticatedResult,
            String stature,
            UserType userType, String headPhoto,
            Sex sex, String nation,
            String diseasesHistory, Integer workYear,
            String politicsStatus,
            String militaryStatus,
            String education,
            String householdType,
            String nativePlace,
            String maritalStatus,
            String oneInchColorWhitePhoto,
            String twoInchColorBluePhoto,
            String cid,
            String emergencyContact,
            String emergencyPhone,
            String licenseLevel,
            String thirdPartyLoginNo,
            String imIdentity,
            LocationRequest placeOfNow,
            AppealStatus appealStatus,
            String lastAppealResult,
            Date lastAppealTime) {
        return new UserProfileGetResponse(id, name, telephone, lonLatJson, birthdate,
                checkedStatus, authenticateStatus, authenticatedResult,
                stature,
                headPhoto, sex, nation, diseasesHistory, workYear, politicsStatus,
                militaryStatus, education, householdType, nativePlace, maritalStatus,
                oneInchColorWhitePhoto, twoInchColorBluePhoto, cid,
                emergencyContact,
                emergencyPhone,
                licenseLevel,thirdPartyLoginNo,imIdentity,
                placeOfNow, appealStatus, lastAppealResult, lastAppealTime);
    }

}
