package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

@Getter
public class OrganizationGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String unifySocialCreditCode;
    private final String unifySocialCreditCodeFile;
    private final String logoPath;
    private final LocationResponse placeOfRegister;
    private final LocationResponse placeOfBusiness;

    /**
     * 机构类型
     */
    private final String institutionalCode;
    /**
     * 行业类型
     */
    private final String industryCode;
    /**
     * 系统名称
     */
    private final String sysName;
    /**
     * 描述
     */
    private final String description;
    /**
     * 经度
     */
    private final Double longitude;
    /**
     * 纬度
     */
    private final Double latitude;

    private String lonLatJson;


    public OrganizationGetResponse(String id, String name,
                                   String unifySocialCreditCode,
                                   String unifySocialCreditCodeFile,
                                   String logoPath,
                                   String sysName,
                                   String institutionalCode,
                                   String industryCode,
                                   String description,
                                   Double longitude,
                                   Double latitude,
                                   LocationResponse placeOfRegister,
                                   LocationResponse placeOfBusiness,
                                   String lonLatJson) {
        this.id = id;
        this.name = name;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.logoPath = logoPath;
        this.sysName = sysName;
        this.institutionalCode = institutionalCode;
        this.industryCode = industryCode;
        this.description = description;
        this.longitude = longitude;
        this.latitude = latitude;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.lonLatJson = lonLatJson;
    }

    @Getter
    public static class LocationResponse extends ResponseAbstract {
        private final ItemValueResponse province;
        private final ItemValueResponse city;
        private final ItemValueResponse district;
        private final String address;

        public LocationResponse(ItemValueResponse province, ItemValueResponse city,
                                ItemValueResponse district, String address) {
            this.province = province;
            this.city = city;
            this.district = district;
            this.address = address;
        }
    }

    @Getter
    public static class ItemValueResponse extends ResponseAbstract {
        private final String code;
        private final String name;

        public ItemValueResponse(String code, String name) {
            this.code = code;
            this.name = name;
        }
    }
}
