package com.bcxin.api.interfaces.tenants.requests.organizations;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * @author huangdunye
 * 2023/5/8 14:58
 */
@ApiModel("邀请注册信息")
@Data
public class TenantOrganizationRequests extends RequestAbstract {
    /**
     * 主键
     */
    @ApiModelProperty(value = "主键id")
    @NotEmpty
    private String id;
    /**
     * 行业类型
     */
    @ApiModelProperty(value = "行业类型")
    @NotEmpty
    private String industryCode;
    /**
     * 机构类型
     */
    @ApiModelProperty(value = "机构类型")
    @NotEmpty
    private String institutionalCode ;
    /**
     * 内网许可审批的请求内容
     */
    @ApiModelProperty(value = "内网许可审批的请求内容")
    @NotEmpty
    private String content;
    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态")
    @NotEmpty
    private Integer status;
    /**
     * 系统生成的注册编码 created_time
     */
    @ApiModelProperty(value = "系统生成的注册编码")
    @NotEmpty
    private String number;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @NotEmpty
    private Date createdTime;

    /**
     * 注册成功之后引用tenant_organizations.id
     */
    @ApiModelProperty(value = "注册成功之后引用tenant_organizations.id")
    @NotEmpty
    private String referenceId ;

}
