package com.bcxin.api.interfaces.tenants.requests.operatelog;

import com.bcxin.api.interfaces.CriteriaAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * description：查询操作日志请求对象
 * author：linchunpeng
 * date：2023/12/14
 */
@ApiModel("查询操作日志请求对象")
@Data
public class SearchOperateLogRequest extends CriteriaAbstract {

    @ApiModelProperty(value = "姓名")
    private String realName;

    @ApiModelProperty(value = "账号")
    private String userName;

    @ApiModelProperty(value = "操作类型：1登录")
    private Integer operateType;

    @ApiModelProperty(value = "操作时间-开始，yyyy-MM-dd")
    private String operateTimeStart;

    @ApiModelProperty(value = "操作时间-结束，yyyy-MM-dd")
    private String operateTimeEnd;

    public int getSkip() {
        int index = this.getPageIndex() - 1;
        if (index < 0) {
            index = 0;
        }

        return this.getPageSize() * index;
    }
}
