package com.bcxin.api.interfaces.tenants.requests.operatelog;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * description：平台操作日志表-新增
 * author：linchunpeng
 * date：2024/11/12
 */
@ApiModel("平台操作日志表-新增")
@Data
public class PlatformOperateLogRequest implements Serializable {

    @ApiModelProperty(value = "用户id")
    private String tenantUserId;

    @ApiModelProperty(value = "职员id")
    private String employeeId;

    @ApiModelProperty(value = "姓名")
    private String realName;

    @ApiModelProperty(value = "操作类型：1修改用户姓名，2重新实名认证，3企业审批通过，4企业审批不通过，5重置密码")
    private Integer operateType;

    @ApiModelProperty(value = "被操作的用户id")
    private String operateUserId;

    @ApiModelProperty(value = "操作内容")
    private String operateContent;

    @ApiModelProperty(value = "操作原因")
    private String operateReason;

    @ApiModelProperty(value = "IP地址")
    private String ipAddress;

    public PlatformOperateLogRequest(String tenantUserId, String employeeId, String realName, Integer operateType, String operateUserId, String operateContent, String operateReason, String ipAddress) {
        this.tenantUserId = tenantUserId;
        this.employeeId = employeeId;
        this.realName = realName;
        this.operateType = operateType;
        this.operateUserId = operateUserId;
        this.operateContent = operateContent;
        this.operateReason = operateReason;
        this.ipAddress = ipAddress;
    }
}
