package com.bcxin.api.interfaces.identities.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class ToCWechatCgiBinSignInResponse extends ResponseAbstract {
    /**
     * 小程序Token
     * 区别于智能人事的AuthenticationToken和AccessToken
     */
    @ApiModelProperty("小程序登入的认证信息; 未绑定用户之前; 用于调用: /wechat/cgi-bin/current")
    private final String cgiToken;

    @ApiModelProperty("仅当关联了用户信息之后(百保盾用户绑定微信或者身份核验之后, 此才有值);那么通过token调用/tenant/users/current 获取用户信息")
    private final String token;

    @ApiModelProperty("微信昵称信息")
    private final String nicky;

    /**
     * 是否已经关联了自然人用户(TenantUser)
     * @return
     */
    @ApiModelProperty("是否已经关联了自然人用户; 此值为true; 那么通过token调用/tenant/users/current 获取用户信息; 否则调用/wechat/cgi-bin/current")
    public boolean getIsAssociatedUser() {
        return StringUtils.hasLength(this.getToken());
    }

    public ToCWechatCgiBinSignInResponse(String cgiToken,String token, String nicky) {
        this.cgiToken = cgiToken;
        this.token = token;
        this.nicky = nicky;
    }

    public static ToCWechatCgiBinSignInResponse create(String cgiToken,String token, String nicky) {
        return new ToCWechatCgiBinSignInResponse(cgiToken, token, nicky);
    }
}
