package com.bcxin.security.api.impls;

import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.security.AttendSitePersonRpcProvider;
import com.bcxin.api.interfaces.security.responses.AttendSitePersonResponse;
import com.bcxin.api.interfaces.tenants.requests.employees.EmployeeRequest;
import com.bcxin.api.interfaces.tenants.responses.InviteAttendSiteResponse;
import com.bcxin.security.api.config.AttendPerConfig;
import com.bcxin.security.domains.entities.AttendSiteEntity;
import com.bcxin.security.domains.entities.AttendSitePersonEntity;
import com.bcxin.security.domains.repositories.AttendSitePersonRepository;
import com.bcxin.security.domains.repositories.AttendSiteRepository;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;

import java.util.Optional;

/**
 * @author linqinglin
 * @date 2021/12/11 0011 15:21
 */

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000, methods = {
        @Method(name = "create",retries = 0,timeout = 10_000)
})
public class AttendSitePersonRpcProviderImpl implements AttendSitePersonRpcProvider {


    private final AttendSitePersonRepository attendSitePersonRepository;

    private final AttendSiteRepository attendSiteRepository;

    public AttendSitePersonRpcProviderImpl(AttendSitePersonRepository attendSitePersonRepository,
                                           AttendSiteRepository attendSiteRepository){
        this.attendSitePersonRepository = attendSitePersonRepository;
        this.attendSiteRepository = attendSiteRepository;
    }

    @Override
    public AttendSitePersonResponse findByEmployeeId(String employeeId) {
        AttendSitePersonEntity attendPer = attendSitePersonRepository.findByEmployeeId(employeeId);
        return AttendSitePersonResponse.create(attendPer.getId(),attendPer.getSecurityName());
    }

    @Override
    public String create(InviteAttendSiteResponse response, EmployeeRequest request, String employeeId) {
        Optional<AttendSiteEntity> attendSiteEntity = attendSiteRepository.findById(response.getAttendSiteId());

        if(!attendSiteEntity.isPresent()){
            throw  new SecurityException("考勤点不存在！");
        }

        AttendSitePersonEntity attendSitePersonEntity = attendSitePersonRepository.findByEmployeeId(employeeId);
        if(attendSitePersonEntity != null){
            throw new NotAllowedTenantException("已存在驻勤点中");
        }

        AttendSiteEntity attendSite = attendSiteEntity.get();
        AttendSitePersonEntity attendPer = AttendSitePersonEntity.create(
                request.getName(),
                employeeId,
                request.getCredential().getType(),
                request.getCredential().getNumber(),
                request.getTelephone(),
                response.getDepartName(),
                request.getOccupationType(),
                "",
                "",
                request.getName(),
                response.getAttendSiteId(),
                response.getOrganizationId(),
                employeeId,
                response.getDepartId(),
                response.getDepartId(),
                employeeId,
                attendSite.getApplicationId(),
                AttendPerConfig.getFormId(),
                AttendPerConfig.getFormName()
        );
        attendSitePersonRepository.save(attendPer);
        return attendPer.getId();
    }
}
