/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.LockProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.RetryableTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import com.bcxin.api.interfaces.buses.requests.MessageRequest;
import com.bcxin.api.interfaces.commons.PlatformOperateLogRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.operatelog.PlatformOperateLogRequest;
import com.bcxin.tenant.domain.DomainConstraint;
import com.bcxin.tenant.domain.conditions.TenantUserSameValidator;
import com.bcxin.tenant.domain.conditions.requests.TenantUserSameCheckRequest;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.RegionEntity;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.entities.valueTypes.ItemValueType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;
import com.bcxin.tenant.domain.events.OrganizationCreatedEvent;
import com.bcxin.tenant.domain.events.OrganizationUpdatedEvent;
import com.bcxin.tenant.domain.repositories.OrganizationAdminRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.RegionRepository;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import com.bcxin.tenant.domain.repositories.TenantUserRepository;
import com.bcxin.tenant.domain.repositories.dtos.TenantUserRepositoryDto;
import com.bcxin.tenant.domain.services.ExternalMemberService;
import com.bcxin.tenant.domain.services.OrganizationAdminService;
import com.bcxin.tenant.domain.services.OrganizationService;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.TenantUserService;
import com.bcxin.tenant.domain.services.commands.BatchCreateTenantUserCommand;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import com.bcxin.tenant.domain.services.commands.externalMembers.CreateOrgExternalMemberCommand;
import com.bcxin.tenant.domain.services.commands.organizations.ApproveCompanyCommand;
import com.bcxin.tenant.domain.services.commands.organizations.CreateMyOrganizationCommand;
import com.bcxin.tenant.domain.services.commands.organizations.ItemValueCommandItem;
import com.bcxin.tenant.domain.services.commands.organizations.LocationCommandItem;
import com.bcxin.tenant.domain.services.commands.organizations.RegisterCompanyCommand;
import com.bcxin.tenant.domain.services.commands.organizations.UpdateCompanyCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.NotifyNewUserCommand;
import com.bcxin.tenant.domain.utils.PassAssembleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service
public class OrganizationServiceImpl
implements OrganizationService {
    private final Logger logger = LoggerFactory.getLogger(OrganizationServiceImpl.class);
    private final OrganizationRepository organizationRepository;
    private final RegionRepository regionRepository;
    private final TenantEventRepository tenantEventRepository;
    private final TenantUserService userService;
    private final PlatformTransactionManager transactionManager;
    private final UnitWork unitWork;
    private final OrganizationAdminRepository organizationAdminRepository;
    private final OrganizationAdminService organizationAdminService;
    private final EnvConfig envConfig;
    private final TenantEventService tenantEventService;
    private final RetryProvider retryProvider;
    private final LockProvider lockProvider;
    private final TenantEventRepository eventRepository;
    private final MessageRpcProvider messageRpcProvider;
    private final TenantUserRepository tenantUserRepository;
    private final TenantUserSameValidator tenantUserSameValidator;
    private final JsonProvider jsonProvider;
    private final PlatformOperateLogRpcProvider platformOperateLogRpcProvider;
    private final ExternalMemberService externalMemberService;

    public OrganizationServiceImpl(OrganizationRepository organizationRepository, RegionRepository regionRepository, TenantEventRepository tenantEventRepository, TenantUserService userService, PlatformTransactionManager transactionManager, UnitWork unitWork, OrganizationAdminRepository organizationAdminRepository, OrganizationAdminService organizationAdminService, EnvConfig envConfig, TenantEventService tenantEventService, RetryProvider retryProvider, LockProvider lockProvider, TenantEventRepository eventRepository, MessageRpcProvider messageRpcProvider, TenantUserRepository tenantUserRepository, TenantUserSameValidator tenantUserSameValidator, JsonProvider jsonProvider, PlatformOperateLogRpcProvider platformOperateLogRpcProvider, ExternalMemberService externalMemberService) {
        this.organizationRepository = organizationRepository;
        this.regionRepository = regionRepository;
        this.tenantEventRepository = tenantEventRepository;
        this.userService = userService;
        this.transactionManager = transactionManager;
        this.unitWork = unitWork;
        this.organizationAdminRepository = organizationAdminRepository;
        this.organizationAdminService = organizationAdminService;
        this.envConfig = envConfig;
        this.tenantEventService = tenantEventService;
        this.retryProvider = retryProvider;
        this.lockProvider = lockProvider;
        this.eventRepository = eventRepository;
        this.messageRpcProvider = messageRpcProvider;
        this.tenantUserRepository = tenantUserRepository;
        this.tenantUserSameValidator = tenantUserSameValidator;
        this.jsonProvider = jsonProvider;
        this.platformOperateLogRpcProvider = platformOperateLogRpcProvider;
        this.externalMemberService = externalMemberService;
    }

    @Override
    public void update(UpdateCompanyCommand command) {
        try {
            this.unitWork.executeTran(() -> {
                Optional optional = this.organizationRepository.findById(command.getId());
                OrganizationEntity organization = (OrganizationEntity)((Object)((Object)optional.get()));
                organization.change(command.getSysName(), command.getDescription(), command.getLogoPath(), command.getLongitude(), command.getLatitude(), command.getInstitutionalCode(), command.getIndustryDetailType(), command.getName(), command.getType(), command.getTelephone(), command.getEconomicType(), command.getNature(), this.translate2LocationValueType(command.getPlaceOfRegister()), this.translate2LocationValueType(command.getPlaceOfBusiness()), command.getParentName(), command.getParentCertificateType(), command.getParentCertificateNumber(), command.getParentLegalPersonName(), command.getParentLegalPersonTelephone(), command.getLegalPersonName(), command.getLegalPersonTelephone(), command.getLegalPersonCredentialType(), command.getLegalPersonCredentialNumber(), command.getLegalPersonNationality(), command.getSecurityPersonName(), command.getSecurityPersonTelephone(), command.getSecurityPersonCredentialType(), command.getSecurityPersonCredentialNumber(), command.getRegisteredCapital(), command.getFixedCapital(), command.getAnnualSalesVolume(), command.getAnnualProfitTax(), command.getCertificateType(), command.getUnifySocialCreditCode(), command.getUnifySocialCreditCodeFile(), command.getServicePermitNumber(), command.getNameOfIssuingAuthority(), command.getFirstIssueServicePermit(), command.getServicePermitAttachment(), command.getSecurityApprovalNumber(), command.getServiceScopeList(), command.getSecurityPreparednessRating(), command.getSecurityArmedRating(), command.getSecuritySafetyDefenseRating(), command.getIsRiskAssessment(), command.getTrainContent(), command.getNumberOfSecurityGuards(), command.getIsPublicSecuritySecurity(), command.getIsPropertyEnterprise(), command.getNatureOfSelfRecruitedUnits(), command.getPlaceOfSupervise(), command.getSuperviseDepartId(), command.getSuperviseDepartName(), command.getFax(), command.getAdminUserName(), command.getAdminUserTelephone(), this.jsonProvider, command.getLocationAddress());
                ((EventDispatcher)TenantContext.getInstance().resolve(EventDispatcher.class)).dispatch((DomainEventAbstract)OrganizationUpdatedEvent.create(organization));
                this.organizationRepository.save(organization);
            });
        }
        catch (Exception ex) {
            if (DomainConstraint.isUniqueConstraintIssue(ex)) {
                throw new ConflictTenantException("\u8be5\u4f01\u4e1a\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728!");
            }
            throw ex;
        }
    }

    @Override
    public void create(CreateMyOrganizationCommand command) {
        TenantUserEntity tenantUser = this.tenantUserRepository.findById(command.getTenantUserId()).orElse(null);
        if (tenantUser == null) {
            throw new NotFoundTenantException("\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
        command.validate();
        try {
            this.unitWork.executeTran(() -> {
                OrganizationEntity organization = OrganizationEntity.createBasic(command.getIndustryCode(), command.getInstitutionalCode(), command.getName(), tenantUser.getTelephone());
                DepartmentEntity department = organization.getDepartments().stream().findFirst().orElse(null);
                organization.addEmployee(department, MasterSlaveType.Master, tenantUser, "\u7cfb\u7edf\u7ba1\u7406\u5458", true, AuthUtil.getCurrentOperator());
                organization.setCompanyEntity(command);
                organization.changeOwner(tenantUser);
                if (command.isAsTeamMember()) {
                    this.externalMemberService.create(CreateOrgExternalMemberCommand.create(organization, tenantUser));
                }
                HashMap<String, String> dynamic = new HashMap<String, String>();
                ((EventDispatcher)TenantContext.getInstance().resolve(EventDispatcher.class)).dispatch((DomainEventAbstract)OrganizationCreatedEvent.create(organization, organization.getName(), dynamic));
                this.organizationRepository.save(organization);
                organization.getEmployees().forEach(ii -> ii.dispatchAfterCreatedEvent(this.envConfig.isRequiredPhoneAsLoginName()));
            });
        }
        catch (Exception ex) {
            if (DomainConstraint.isUniqueConstraintIssue(ex)) {
                throw new ConflictTenantException("\u8be5\u4f01\u4e1a\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728!");
            }
            throw ex;
        }
    }

    @Override
    public void dispatch(NotifyNewUserCommand command) {
        AtomicReference OrganizationAtomic = new AtomicReference();
        this.retryProvider.execute(() -> {
            Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
            if (!tenantUserOptional.isPresent()) {
                throw new RetryableTenantException();
            }
            OrganizationAtomic.set(tenantUserOptional.get());
        }, 10);
        TenantUserEntity tenantUserEntity = (TenantUserEntity)((Object)OrganizationAtomic.get());
        this.lockProvider.execute(String.format("nf_%s", command.getEventId()), () -> {
            Optional tenantEventOptional = this.eventRepository.findById(command.getEventId());
            if (!tenantEventOptional.isPresent()) {
                return;
            }
            if (((TenantEventEntity)tenantEventOptional.get()).getEventAction() != EventAction.OrganizationEvenForSms) {
                throw new BadTenantException(String.format("\u7a0b\u5e8f\u6709\u8bef, \u8be5\u4e8b\u4ef6(%s, %s)\u5e76\u4e0d\u662f\u5904\u7406SMS\u6d88\u606f\u5185\u5bb9", new Object[]{((TenantEventEntity)tenantEventOptional.get()).getId(), ((TenantEventEntity)tenantEventOptional.get()).getEventAction()}));
            }
            TenantEventEntity selectedTenantEvent = (TenantEventEntity)tenantEventOptional.get();
            if (selectedTenantEvent.getStatus() == EventProcessedStatus.Processed) {
                this.logger.error("\u91cd\u590d\u77ed\u4fe1-\u8be5\u77ed\u4fe1\u4e4b\u524d\u5df2\u7ecf\u53d1\u9001\u8fc7(id={})", (Object)selectedTenantEvent.getId());
                return;
            }
            String pass = PassAssembleUtils.assemble(tenantUserEntity.getSelectIdNum(), this.envConfig.getPassPrefix());
            HashMap<String, String> huaWeiSmsContent = new HashMap<String, String>();
            huaWeiSmsContent.put("smsCode", "B99");
            ArrayList<String> sendParams = new ArrayList<String>();
            sendParams.add(pass);
            huaWeiSmsContent.put("params", JSON.toJSONString(sendParams));
            String telephone = tenantUserEntity.getTelephone();
            huaWeiSmsContent.put("mobile", telephone);
            this.messageRpcProvider.dispatch(MessageRequest.create((MessageType)MessageType.SMS, huaWeiSmsContent));
            this.unitWork.executeNewTran(() -> {
                selectedTenantEvent.done("\u4e8b\u4ef6\u6d88\u8d39\u6210\u529f-\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                this.eventRepository.save((EntityAbstract)selectedTenantEvent);
            });
        });
    }

    @Override
    public String register(RegisterCompanyCommand command) {
        command.validate();
        ArrayList<BatchCreateTenantUserCommand.TenantUserCommandItem> commandItems = new ArrayList<BatchCreateTenantUserCommand.TenantUserCommandItem>();
        if (command.getAdministrator() != null) {
            commandItems.add(OrganizationServiceImpl.translate2UserCommandItem(command.getAdministrator()));
        }
        Collection sameCheckRequests = commandItems.stream().map(ii -> TenantUserSameCheckRequest.create(ii.getCredentialType(), ii.getCredentialNumber(), ii.getTelephone())).collect(Collectors.toList());
        this.tenantUserSameValidator.validate(sameCheckRequests);
        Collection<TenantUserEntity> tenantUsers = this.userService.create(BatchCreateTenantUserCommand.create(commandItems));
        try {
            String notExistsIdNums = commandItems.stream().map(BatchCreateTenantUserCommand.TenantUserCommandItem::getCredentialNumber).distinct().filter(ii -> tenantUsers.stream().noneMatch(ix -> ix.getSelectedCredential().getNumber().equals(ii))).collect(Collectors.joining(","));
            if (StringUtils.isNotBlank((CharSequence)notExistsIdNums)) {
                throw new BadTenantException(String.format("\u7cfb\u7edf\u5f02\u5e38, \u65e0\u6cd5\u521b\u5efa\u79df\u6237(%s)\u4fe1\u606f", notExistsIdNums));
            }
            TenantUserEntity organizationCreator = tenantUsers.stream().filter(ii -> ii.getSelectedCredential().getNumber().equals(command.getAdministrator().getCredentialNumber())).findFirst().get();
            AtomicReference organizationId = new AtomicReference();
            this.unitWork.executeTran(() -> {
                OrganizationEntity organization = OrganizationEntity.create(command.getIndustryCode(), command.getInstitutionalCode(), command.getName(), command.getTelephone(), command.getType(), command.getIndustryDetailType(), command.getPlaceOfSupervise().getDistrict().getCode(), command.getSuperviseDepartId(), command.getSuperviseDepartName(), command.getShareOrganizationId(), command.getShareOrganizationName(), command.getShareEmployeeId(), command.getShareEmployeeName(), command.getDynamic());
                organization.change(this.translate2LocationValueType(command.getPlaceOfRegister()), this.translate2LocationValueType(command.getPlaceOfBusiness()));
                organizationId.set(organization.getId());
                DepartmentEntity department = null;
                if (organization.getDepartments() != null && organization.getDepartments().size() > 0) {
                    department = organization.getDepartments().stream().findFirst().get();
                }
                for (TenantUserEntity tenantUser : tenantUsers) {
                    MasterSlaveType slaveType = MasterSlaveType.Normal;
                    String position = "\u666e\u901a\u5458\u5de5";
                    boolean isDomainAdmin = false;
                    if (command.getAdministrator() != null && tenantUser.getSelectedCredential().getNumber().equals(command.getAdministrator().getCredentialNumber())) {
                        position = "\u7cfb\u7edf\u7ba1\u7406\u5458";
                        slaveType = MasterSlaveType.Master;
                        isDomainAdmin = true;
                    }
                    organization.addEmployee(department, slaveType, tenantUser, position, isDomainAdmin, AuthUtil.getCurrentOperator());
                }
                organization.setCompanyEntity(command);
                organization.changeOwner(organizationCreator);
                ((EventDispatcher)TenantContext.getInstance().resolve(EventDispatcher.class)).dispatch((DomainEventAbstract)OrganizationCreatedEvent.create(organization, organization.getName(), command.getDynamic()));
                this.organizationRepository.save(organization);
                organization.getEmployees().forEach(ii -> ii.dispatchAfterCreatedEvent(this.envConfig.isRequiredPhoneAsLoginName()));
            });
            return (String)organizationId.get();
        }
        catch (Exception ex) {
            if (DomainConstraint.isUniqueConstraintIssue(ex)) {
                throw new ConflictTenantException("\u8be5\u4f01\u4e1a\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728!");
            }
            throw ex;
        }
    }

    @Override
    public void dispatch(ApproveCompanyCommand command) {
        Optional organizationOptional = this.organizationRepository.findById(command.getId());
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u4f01\u4e1a\u4fe1\u606f");
        }
        OrganizationEntity organization = (OrganizationEntity)((Object)organizationOptional.get());
        String name = organization.getName();
        this.unitWork.executeTran(() -> {
            organization.approve(command.isApproved() ? ApprovedStatus.Passed : ApprovedStatus.NoPassed, command.getNote());
            if (!command.isApproved()) {
                organization.abandon();
            }
            this.organizationRepository.save(organization);
            TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
            this.platformOperateLogRpcProvider.logOperate(new PlatformOperateLogRequest(userModel.getId(), userModel.getEmployeeId(), userModel.getName(), Integer.valueOf(command.isApproved() ? 3 : 4), null, command.isApproved() ? "\u4f01\u4e1a\uff1a" + name + "\uff0c\u5ba1\u6279\u901a\u8fc7" : "\u4f01\u4e1a\uff1a" + name + "\uff0c\u5ba1\u6279\u4e0d\u901a\u8fc7", command.getNote(), null));
        });
        Collection<TenantUserRepositoryDto> tenantUsers = this.organizationRepository.getOrganization(organization.getId(), TrueFalseStatus.True, command.isApproved() ? ApprovedStatus.Passed : ApprovedStatus.NoPassed);
        if (CollectionUtil.isNotEmpty(tenantUsers)) {
            if (organization.getApprovedInformationValueType() != null && organization.getApprovedInformationValueType().getStatus() == ApprovedStatus.Passed) {
                tenantUsers.stream().forEach(tenantUser -> this.tenantEventService.create(CreateTenantEventCommand.create(EventAction.OrganizationEvenForSms, tenantUser.getId(), tenantUser.getTelephone())));
            } else {
                tenantUsers.forEach(tenantUser -> {
                    HashMap<String, String> huaWeiSmsContent = new HashMap<String, String>();
                    huaWeiSmsContent.put("smsCode", "B08");
                    ArrayList<String> sendParams = new ArrayList<String>();
                    sendParams.add(command.getNote());
                    huaWeiSmsContent.put("params", JSON.toJSONString(sendParams));
                    String telephone = tenantUser.getTelephone();
                    huaWeiSmsContent.put("mobile", telephone);
                    this.messageRpcProvider.dispatch(MessageRequest.create((MessageType)MessageType.SMS, huaWeiSmsContent));
                });
            }
        }
    }

    private static BatchCreateTenantUserCommand.TenantUserCommandItem translate2UserCommandItem(RegisterCompanyCommand.ContactCommandItem contact) {
        return BatchCreateTenantUserCommand.TenantUserCommandItem.create(contact.getName(), contact.getTelephone(), contact.getCredentialType(), contact.getCredentialNumber(), contact.getNationality());
    }

    private static void pushAndValidateCommandItem(Collection<BatchCreateTenantUserCommand.TenantUserCommandItem> commandItems, BatchCreateTenantUserCommand.TenantUserCommandItem newItem) {
        if (commandItems.stream().anyMatch(ii -> ii.getTelephone().equals(newItem.getTelephone()) && ii.getCredentialType().equals((Object)newItem.getCredentialType()) && !ii.getCredentialNumber().equals(newItem.getCredentialNumber()))) {
            throw new BadTenantException(String.format("\u624b\u673a\u4e0e\u8bc1\u4ef6\u53f7(%s)\u5339\u914d\u5b58\u5728\u51b2\u7a81", newItem.getCredentialNumber()));
        }
        if (commandItems.stream().anyMatch(ii -> !ii.getTelephone().equals(newItem.getTelephone()) && ii.getCredentialType().equals((Object)newItem.getCredentialType()) && ii.getCredentialNumber().equals(newItem.getCredentialNumber()))) {
            throw new BadTenantException(String.format("\u624b\u673a\u4e0e\u8bc1\u4ef6\u53f7(%s)\u5339\u914d\u5b58\u5728\u51b2\u7a81", newItem.getCredentialNumber()));
        }
        commandItems.add(newItem);
    }

    protected LocationValueType translate2LocationValueType(LocationCommandItem locationCommandItem) {
        if (locationCommandItem == null) {
            return null;
        }
        return LocationValueType.create(this.translate2ItemValueType(locationCommandItem.getProvince()), this.translate2ItemValueType(locationCommandItem.getCity()), this.translate2ItemValueType(locationCommandItem.getDistrict()), locationCommandItem.getAddress());
    }

    private ItemValueType translate2ItemValueType(ItemValueCommandItem item) {
        Optional region;
        if (item == null) {
            return ItemValueType.create(null, null);
        }
        if (StringUtils.isBlank((CharSequence)item.getCode())) {
            return ItemValueType.create(null, null);
        }
        String name = item.getName();
        if (StringUtils.isBlank((CharSequence)name) && (region = this.regionRepository.findById(item.getCode())).isPresent()) {
            name = ((RegionEntity)((Object)region.get())).getRegionName();
        }
        return ItemValueType.create(item.getCode(), name);
    }
}

