/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.ValidStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Table(name="tenant_contracts")
@Entity
public class ContractEntity
extends OpEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="name", length=1000)
    private String name;
    @ManyToOne
    @JoinColumn(name="employee_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(name="fk_tenant_contract_employee_id", value=ConstraintMode.CONSTRAINT))
    private EmployeeEntity employee;
    @ManyToOne
    @JoinColumn(name="organization_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(name="fk_tenant_contract_organization_id", value=ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;
    @Column(name="a_name", length=500)
    private String aName;
    @Column(name="b_name", length=500)
    private String bName;
    @Column(name="begin_date", nullable=false)
    @Temporal(value=TemporalType.DATE)
    private Date beginDate;
    @Column(name="end_date", nullable=true)
    @Temporal(value=TemporalType.DATE)
    private Date endDate;
    @Column(name="date_limit_less", nullable=false)
    private TrueFalseStatus dateLimitless;
    @Column(name="attachment")
    private String attachment;
    @Column(name="note", length=2000)
    private String note;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private ValidStatus status;
    @Column(name="status_note", length=500)
    private String statusNote;

    public void change(String name, String aName, String bName, String note, Date beginDate, Date endDate, boolean dateLimitless) {
        this.setName(name);
        this.setAName(aName);
        this.setBName(bName);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setNote(note);
        this.setDateLimitless(dateLimitless ? TrueFalseStatus.True : TrueFalseStatus.False);
    }

    public void changeAttachment(String attachment) {
        this.setAttachment(attachment);
    }

    public void changeNote(String note) {
        this.setNote(note);
    }

    public void changeStatus(ValidStatus status, String statusNote) {
        this.setStatus(status);
        this.setStatusNote(statusNote);
    }

    protected ContractEntity() {
    }

    public static ContractEntity create(EmployeeEntity employee, String name, String aName, String bName, Date beginDate, Date endDate, boolean dateLimitless) {
        ContractEntity contract = new ContractEntity();
        contract.setId(UUIDUtil.getShortUuid());
        contract.setName(name);
        contract.setEmployee(employee);
        contract.setAName(aName);
        contract.setBName(bName);
        contract.setBeginDate(beginDate);
        contract.setEndDate(endDate);
        contract.setDateLimitless(dateLimitless ? TrueFalseStatus.True : TrueFalseStatus.False);
        contract.setStatus(ValidStatus.Valid);
        contract.setOrganization(employee.getOrganization());
        return contract;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public EmployeeEntity getEmployee() {
        return this.employee;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public String getAName() {
        return this.aName;
    }

    public String getBName() {
        return this.bName;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public TrueFalseStatus getDateLimitless() {
        return this.dateLimitless;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public String getNote() {
        return this.note;
    }

    public ValidStatus getStatus() {
        return this.status;
    }

    public String getStatusNote() {
        return this.statusNote;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setEmployee(EmployeeEntity employee) {
        this.employee = employee;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setAName(String aName) {
        this.aName = aName;
    }

    protected void setBName(String bName) {
        this.bName = bName;
    }

    protected void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    protected void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    protected void setDateLimitless(TrueFalseStatus dateLimitless) {
        this.dateLimitless = dateLimitless;
    }

    protected void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setStatus(ValidStatus status) {
        this.status = status;
    }

    protected void setStatusNote(String statusNote) {
        this.statusNote = statusNote;
    }
}

