package com.bcxin.runtime.domain.repositories.syncs.repositories;

import com.bcxin.runtime.domain.syncs.entities.DataSyncMapEntity;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncMapRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface JpaDataMapSyncRepository extends JpaRepository<DataSyncMapEntity,String>,
        DataSyncMapRepository {

    @Query("select d from DataSyncMapEntity d where d.mapKey in ?1 order by d.id ")
    Collection<DataSyncMapEntity> getAllByMapKeys(Collection<String> mapKeys);

    @Query("select d from DataSyncMapEntity d where d.mapKey like '%.+%'")
    Collection<DataSyncMapEntity> getAllRegexByMapKeys();
}
