package com.bcxin.runtime.domain.repositories.syncs.components.impls;

import com.bcxin.runtime.domain.repositories.syncs.components.SqlParser;
import com.bcxin.runtime.domain.snapshoots.JdbcConnectionSnapshot;
import com.bcxin.runtime.domain.snapshoots.TableMapSnapshot;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.saas.core.AppConfigProperty;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import java.util.*;

@Component(JdbcConnectionSnapshot.POSTGRESQL_PARSER_BEAN_NAME)
public class SqlParserPostgreSqlImpl extends SqlParserAbstract  implements SqlParser  {

    public SqlParserPostgreSqlImpl(JsonProvider jsonProvider,
                                   AppConfigProperty appConfigProperty) {
        super(jsonProvider,appConfigProperty);
    }

    @Override
    protected String buildFinalSql(String sql, Collection<String> duplicateColumnNames) {
        /*
        sqlMapping.append(String.format("insert into %s (%s) values(%s) on conflict (id) do update set %s",
                tableMap.getTableName(), columnBuilder, valueBuilder, duplicate_UpdateBuilder));

         */
        if (duplicateColumnNames == null || duplicateColumnNames.size() == 0) {
            return sql;
        }

        StringBuilder duplicate_UpdateBuilderColumns = new StringBuilder();
        StringBuilder duplicate_UpdateBuilderValues = new StringBuilder();
        duplicateColumnNames.forEach(fieldName -> {
            if (duplicate_UpdateBuilderColumns.length() > 0) {
                duplicate_UpdateBuilderColumns.append(",");
                duplicate_UpdateBuilderValues.append(",");
            }
            duplicate_UpdateBuilderColumns.append(fieldName);
            duplicate_UpdateBuilderValues.append(String.format("excluded.%s", fieldName));
        });

        return String.format("%s on conflict (id) do update set (%s) = (%s)",
                sql, duplicate_UpdateBuilderColumns, duplicate_UpdateBuilderValues);
    }

    @Override
    protected Object getFieldValue(TableMapSnapshot.Column ii, DataSetDto.Row row,
                                   Collection<TableMapSnapshot.Column> sourceColumns) {
        Object value = super.getFieldValue(ii, row,sourceColumns);
        if (ii.getFieldName().equalsIgnoreCase("ISTMP")) {
            return value.equals(1) ? true : false;
        } else {
            return value;
        }
    }
}
