#思路
---

因4.4版本使用的是Redis缓存,故部署4.4版本分为五部分。分别为安装Redis、jdk、Mysql、tomcat、部署项目包

环境要求
---

需要准备环境和安装包有：Redis、mysql5.7以上版本、jdk1.8、tomcat8

本次安装部署的系统为CentOS7

配置步骤
---

第一步：安装Redis
---

##安装Redis

###第一步：下载Redis安装包

wget http://download.redis.io/releases/redis-4.0.6.tar.gz

![](imgs/Linux/4.4Linuxinstall01.png)

###第二步：解压压缩包

tar -zxvf redis-4.0.6.tar.gz

![](imgs/Linux/4.4Linuxinstall02.png)

###第三步：yum安装gcc依赖

yum install gcc

![](imgs/Linux/4.4Linuxinstall03.png)

遇到选择，输入y即可

###第四步：跳转到redis解压目录下

cd redis-4.0.6

![](imgs/Linux/4.4Linuxinstall04.png)

###第五步：编译安装

make MALLOC=libc

![](imgs/Linux/4.4Linuxinstall05.png)

将/usr/local/redis-4.0.6/src目录下的文件加到/usr/local/bin目录

cd src && make install

![](imgs/Linux/4.4Linuxinstall06.png)

##启动redis的三种方式

先切换到redis src目录下

![](imgs/Linux/4.4Linuxinstall07.png)

###1、直接启动redis

./redis-server

![](imgs/Linux/4.4Linuxinstall08.png)

如上图：redis启动成功，但是这种启动方式需要一直打开窗口，不能进行其他操作，不太方便。

按 ctrl + c可以关闭窗口。

###2、以后台进程方式启动redis

第一步：修改redis.conf文件

将daemonize no修改为daemonize yes

第二步：指定redis.conf文件启动

./redis-server /usr/local/redis-4.0.6/redis.conf

![](imgs/Linux/4.4Linuxinstall09.png)

第三步：关闭redis进程

首先使用ps -aux \| grep redis查看redis进程

![](imgs/Linux/4.4Linuxinstall10.png)

使用kill命令杀死进程

[root\@iZwz991stxdwj560bfmadtZ src]\# kill 18714

###3、设置redis开机自启动

1、在/etc目录下新建redis目录

mkdir redis

![](imgs/Linux/4.4Linuxinstall11.png)

1.  将/usr/local/redis-4.0.6/redis.conf
    文件复制一份到/etc/redis目录下，并命名为6379.conf

![](imgs/Linux/4.4Linuxinstall12.png)

1.  将redis的启动脚本复制一份放到/etc/init.d目录下

![](imgs/Linux/4.4Linuxinstall13.png)

4、设置redis开机自启动

先切换到/etc/init.d目录下

4.1 先使用vim编辑redisd文件，在第一行加入如下两行注释，保存退出

\# chkconfig: 2345 90 10

\# description: Redis is a persistent key-value database

![](imgs/Linux/4.4Linuxinstall14.png)

再次执行开机自启命令

chkconfig redisd on

现在可以直接已服务的形式启动和关闭redis了

service redisd start　

![](imgs/Linux/4.4Linuxinstall15.png)

第二步：配置JDK
---

###1、JDK下载路径

按需选择，可以选择网络资源也可以选择平台网盘上传的JDK版本

*在线资源：http://vdisk.weibo.com/s/BJD8pmDP8CUsN*

*天翎网盘：*<http://pan.baidu.com/s/1geZhRfP>

###2、解压安装<br>将这个 jdk-8u231-linux-x64.tar.gz放在linux下的某个路径，例如/usr/local/bin/java/，可以通过sftp工具上传

cd /usr/local/bin/java/ //进入到JDK准备存放的路径，可以用ftp工具新建文件夹

//加压文件, 解压到当前目录

tar -zxvf jdk-8u231-linux-x64.tar.gz

###3、安装JDK修改环境变量

vim /etc/profile

//在profile文件末尾加入：

export JAVA_HOME=/usr/local/bin/java/jdk1.8.0_231

export PATH=\$JAVA_HOME/bin:\$PATH

export CLASSPATH=.:\$JAVA_HOME/lib/dt.jar:\$JAVA_HOME/lib/tools.jar

![](imgs/Linux/4.4Linuxinstall16.png)

### 4、加载环境变量

source /etc/profile

### 5、测试是否成功

\$ java -version 

输入类似的打印

1、java version "1.8.0_231"  

2、Java(TM) SE Runtime Environment (build 1.8.0_231-b11)  

3、Java HotSpot(TM) 64-Bit Server VM (build 25.231-b11, mixed mode)

第三步：配置Tomcat
---

### 1、Tomcat下载

地址：<http://pan.baidu.com/s/1geZhRfP>

上传到指定目录 例如/usr/local/bin/tomcat/

### 2、解压安装

tar -zxvf apache-tomcat-8.5.50.tar.gz

### 3、测试tomcat是否成功

输入如下命令

**\#/usr/local/bin/tomcat/apache-tomcat-8.5.50/bin/start.sh start**

如果出现如下打印

**Using CATALINA_BASE:   /usr/local/apache-tomcat-8.5.50/**  
**Using CATALINA_HOME:   /usr/local/apache-tomcat-8.5.50/**

同时在浏览器输入地址*http://localhost:8080/*,输入出现如图，则证明tomcat正常启动

![](imgs/Linux/4.4Linuxinstall17.png)

第四步：Mysql安装配置
---

### 下载rpm文件

没有wget需要先 yum install wget 安装wget

wget <http://dev.mysql.com/get/mysql57-community-release-el7-7.noarch.rpm>

1.  **安装rpm包**

rpm -ivh mysql57-community-release-el7-7.noarch.rpm

1.  **安装meisql **

yum install mysql-community-server

安装过程中有可能需要确认是否安装什么的一直输入y 确认

1.  **安装完成输入mysql -uroot -p 进入数据库**

提示你输入密码 直接去 /var/log/mysqld.log 文件下直接找的密码
输入进去登陆成功，如果mysqld.log里面没有密码则需要通过一下步骤去获取密码

**4.1删除原来安装过的mysql残留的数据 rm -rf /var/lib/mysql**

4.2 重启mysqld服务 systemctl restart mysqld

4.3 再去找临时密码 grep 'temporary password'
/var/log/mysqld.log（执行命令之后后面带有一个自动生成的密码，复制下来重新登陆的时候输入这个密码即可）

**5.登陆成功之后，对密码进行修改，首先先去设置validate_password_policy的值**

5.1set global validate_password_policy=0;

5.2set global validate_password_length=1

5.3set global validate_password_mixed_case_count=2

5.4然后修改密码 :alter user user() identified by ‘123456’; 会提示成功

**6.开通远程权限**

执行grant all privileges on \*.\* to '用户名'\@'%' identified by '登录密码' with
grant option；

刷新权限 flush privileges;

然后用远程链接工具测试 授权成功

**7.修改大小写敏感**

vi /etc/my.cnf

![](imgs/Linux/4.4Linuxinstall18.png)

在【mysqld】区域内添加下列参数

skip-grant-tables

character-set-server=utf8

lower_case_table_names=1

 

对于vi编辑器，vim
my.cnf打开文档后，键盘输入i，才能进行编辑，修改信息，如果保存，按ESC，之后输入!wq，如果不保存ESC，后输入！

新建数据库

输入命令mysql进入mysql控制台页面;

之后输入如下命令新建数据库；

CREATE DATABASE obpm2 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

CREATE DATABASE obpm2_oa DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

之后退出mysql命令界面，输入exit;

重启mysql

/etc/init.d/mysqld stop 停止

/etc/init.d/mysqld start 启动

或者

Systemctl restart mysqld 重启

Systemctl stop mysqld  停止

Systemctl start mysqld 启动

第五步：部署obpm项目包
---

到tomcat的安装目录

cd /usr/local/bin/apache-tomcat-8.5.50/bin

./shutdown.sh

如果tomcat不能正常关闭，这需要根据tomcat端口，关闭相应进程

grep –ef\|8080

kill -9 进程号

###1、解压对应war包

**注意：因4.4版本为前后端分离，前端的包有signon、obpm、km包、后端包designer，（obpm_demo）软件和附件的文件是启动方式的上一级目录上、按照个人的需求进行放置
，演示部署环境前后端没有分开。**

把obpm.war、designer.war、signon.war、km.war复制到tomcat的webapps部署目录下，war包会自动解压缩

cp obpm.war /usr/local/bin/apache-tomcat-8.5.50/webapps/

cp designer.war /usr/local/bin/apache-tomcat-8.5.50/webapps/

cp signon.war /usr/local/bin/apache-tomcat-8.5.50/webapps/

cp km.war /usr/local/bin/apache-tomcat-8.5.50/webapps/

###2、重启tomcat

cd /usr/local/bin/apache-tomcat-8.5.50/bin

./shutdown.sh

./startup.sh

###3、修改obpm的数据库的连接信息

平台默认采用的是mysql数据库，如果想采用其它的数据库，可以在

hibernate.properties、proxool.properties、applicat.yml配置文件中进行修改。

1.  采用默认数据库连接池，修改默认数据库连接，将数据库连接配置为其它数据库连接。

**文件路径：**

vi /usr/local/bin/apache-tomcat-8.5.50/ obpm_dome /proxool.properties

![](imgs/Linux/4.4Linuxinstall19.png)

文件内容：

![](imgs/Linux/4.4Linuxinstall20.png)

**如果想修改用其他的数据库或者数据库地址，进行一下步骤：**

第一步，将默认MySQL配置信息用“\#”注释。

\#\# MySQL

\#jdbc-0.proxool.driver-class=com.mysql.jdbc.Driver

\#jdbc-0.proxool.driver-url=jdbc:mysql://localhost:3306/obpm?useUnicode=true&characte\#rEncoding=utf8

\#jdbc-0.user=root

\#jdbc-0.password=

第二步，启用其它数据库配置信息，将对应配置信息前的“\#”去掉。

\#\# Oracle

jdbc-0.proxool.driver-class=oracle.jdbc.driver.OracleDriver

jdbc-0.proxool.driver-url=jdbc:oracle:thin:\@192.168.0.120:1521:obpm

jdbc-0.user=xapps_dt

jdbc-0.password=xapps_dt

\#\# DB2

\#jdbc-0.proxool.driver-class=com.ibm.db2.jcc.DB2Driver

\#jdbc-0.proxool.driver-url=jdbc:db2://192.168.0.120:50000/obpm

\#jdbc-0.user=obpm_dt

\#jdbc-0.password=obpm_dt

\#\#SQLServer

\#jdbc-0.proxool.driver-class=net.sourceforge.jtds.jdbc.Driver

\#jdbc-0.proxool.driver-url=jdbc:jtds:sqlserver://localhost:1433/obpm

\#jdbc-0.user=obpm_dt

\#jdbc-0.password=obpm_dt

第三步，采用proxool数据库连接池，修改hibernate.properties文件中默认proxool连接池的方言，将方言改为其它数据库连接。

**路径：**

vi /usr/local/bin/apache-tomcat-8.5.50/ obpm_dome /proxool.properties

![](imgs/Linux/4.4Linuxinstall21.png)

**修改：**

先注释掉默认MYSQL配置信息，再启用其它数据库配置信息，将对应配置信息前的“\#”去掉。

文件中数据库的对应连接也需要进行修改

\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#

\#\#\# Proxool Connection Pool\#\#\#

\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#

\#\# Properties for external configuration of Proxool

hibernate.proxool.pool_alias pool1

\#\# Only need one of the following

\#hibernate.proxool.existing_pool true

\#hibernate.dialect org.hibernate.dialect.MySQL5Dialect

hibernate.dialect org.hibernate.dialect.OracleDialect**（启用oracle）**

\#hibernate.dialect cn.myApps\|OBPM.util.dialect.DB2V9Dialect

hibernate.dialect cn.myApps\|OBPM.util.dialect.SQLServerUnicodeDialect

hibernate.connection.release_mode auto

hibernate.proxool.properties proxool.properties

修改后的文件如下图：

![](imgs/Linux/4.4Linuxinstall22.png)

Application.yml文本修改

\# 数据库访问配置

datasource:

driver-class-name: com.mysql.jdbc.Driver

url:
jdbc:mysql://localhost:3307/obpm2?characterEncoding=UTF-8&serverTimezone=GMT

username: root

password: 123456

\# 下面为连接池的补充设置，应用到上面所有数据源中

initialSize: 5

minIdle: 20

maxActive: 200

\# 配置获取连接等待超时的时间

maxWait: 60000

\# 配置间隔多久才进行一次检测，检测需要关闭的空闲连接，单位是毫秒

timeBetweenEvictionRunsMillis: 60000

\# 配置一个连接在池中最小生存的时间，单位是毫秒

minEvictableIdleTimeMillis: 300000

validationQuery: SELECT 1

testWhileIdle: true

testOnBorrow: false

testOnReturn: false

\# 配置监控统计拦截的filters，去掉后监控界面sql无法统计，'wall'用于防火墙

filters: stat,wall,log4j

logSlowSql: true

jpa:

database: mysql

show-sql: true

hibernate:

ddl-auto: update

\#设置默认schema，可以为空

properties:

hibernate:

default_schema:

![](imgs/Linux/4.4Linuxinstall23.png)

全部项目包中WEB-INF/classes下面如果有以上配置文件都需要修改

###4、授权信息

如果需要获得授权控制，需更新替换license文件。

License文件路径如下:

Cd /usr/local/bin/apache-tomcat-8.5.50/obpm_demo/

![](imgs/Linux/4.4Linuxinstall24.png)

###5、备份uploads

如果升级，则需要先备份原来的obpm_obpm/uploads，之后将uploads目录替换回来。
