package com.bcxin.autodownloadupload.service;

import com.bcxin.autodownloadupload.dtos.ChangeLogsRequestDto;
import com.bcxin.autodownloadupload.dtos.FerryTaskPullResult;

/**
 * description: 拉取数据服务
 * author: linchunpeng
 * date:  2023-04-19 9:26
 */
public interface PullDataService {

    /**
     * description：拉取数据-异步调用
     * author：linchunpeng
     * date：2024/3/11
     */
    void pullDataAsync(ChangeLogsRequestDto requestDto, int pullType);

    /**
     * description: 拉取数据
     * author: linchunpeng
     * date:  2023-04-17 16:03
     */
    void pullData(ChangeLogsRequestDto requestDto, int pullType);

    /**
     * description: 旧数据迁移
     * author: linchunpeng
     * date:  2023-04-20 13:13
     */
    void oldDataProcessor(Long begin, Long end);

    /**
     * description：查询自动摆渡结果
     * author：linchunpeng
     * date：2024/6/17
     */
    FerryTaskPullResult queryAutoFerryPullResult(Long id);
}
