/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.sharding.strategy;

import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class ConsistentHashAlgorithm {
    private SortedMap<Long, String> virtualNodes = new TreeMap();
    private static final int VIRTUAL_NODES = 3;

    public ConsistentHashAlgorithm() {
    }

    public ConsistentHashAlgorithm(SortedMap<Long, String> virtualTableNodes, Collection<String> tableNodes) {
        if (Objects.isNull(virtualTableNodes)) {
            virtualTableNodes = this.initNodesToHashLoop(tableNodes);
        }
        this.virtualNodes = virtualTableNodes;
    }

    public SortedMap<Long, String> initNodesToHashLoop(Collection<String> tableNodes) {
        TreeMap<Long, String> virtualTableNodes = new TreeMap<Long, String>();
        for (String node : tableNodes) {
            for (int i = 0; i < 3; ++i) {
                String s = String.valueOf(i);
                String virtualNodeName = node + "-VN" + s;
                long hash = this.getHash(virtualNodeName);
                virtualTableNodes.put(hash, virtualNodeName);
            }
        }
        return virtualTableNodes;
    }

    public String getTableNode(String key) {
        String virtualNode = this.getVirtualTableNode(key);
        if (StringUtils.isNotBlank((CharSequence)virtualNode)) {
            return virtualNode.substring(0, virtualNode.indexOf("-"));
        }
        return null;
    }

    public String getVirtualTableNode(String key) {
        String virtualNode;
        long hash = this.getHash(key);
        SortedMap subMap = this.virtualNodes.tailMap(hash);
        if (subMap.isEmpty()) {
            Long i = (Long)this.virtualNodes.firstKey();
            virtualNode = (String)this.virtualNodes.get(i);
        } else {
            Long i = subMap.firstKey();
            virtualNode = (String)subMap.get(i);
        }
        return virtualNode;
    }

    public long getHash(String key) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < key.length(); ++i) {
            hash = (hash ^ key.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        if ((hash += hash << 5) < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }

    public SortedMap<Long, String> getVirtualNodes() {
        return this.virtualNodes;
    }
}

