package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SyncDataViaDirectlyJobTask extends TaskAbstract {
    private final DataSyncQueueService dataSyncQueueService;

    public SyncDataViaDirectlyJobTask(
            @Qualifier("DataSyncQueueServiceImpl") DataSyncQueueService dataSyncQueueService) {
        this.dataSyncQueueService = dataSyncQueueService;
    }

    @Override
    protected void runCore() {
        dataSyncQueueService.dispatchData();
    }

    @Override
    public String getTaskName() {
        return "sync.data.directly.data";
    }
}
