package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.auth.service.GeneralAuthenticationServiceServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix = "myapps.authentication",name = "enable",havingValue = "true")
public class RealNameAuthenticationTask extends TaskAbstract{
    private final static Logger logger = LoggerFactory.getLogger(RealNameAuthenticationTask.class);

    private final GeneralAuthenticationServiceServiceImpl authenticationAbstract;

    public RealNameAuthenticationTask(GeneralAuthenticationServiceServiceImpl authenticationAbstract) {
        this.authenticationAbstract = authenticationAbstract;
    }

    @Override
    protected void runCore() throws Exception {
        logger.info("实名认证定时器开始实名认证");
        logger.info("开始实名认证---");
        authenticationAbstract.auth();
        logger.info("实名认证结束");
    }

    @Override
    public String getTaskName() {
        return "execute.RealName.authentication";
    }
}
