package com.bcxin.backend.tasks;
import com.bcxin.backend.core.components.StorageProvider;
import com.bcxin.backend.domain.syncs.dtos.SyncDataMeta;
import com.bcxin.backend.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import com.bcxin.saas.core.components.JsonProvider;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;

@Component
public class CleanSyncDataJobTask extends TaskAbstract{
    private final DataSyncQueueRepository dataSyncQueueRepository;
    private final JsonProvider jsonProvider;
    private final StorageProvider storageProvider;

    public CleanSyncDataJobTask(DataSyncQueueRepository dataSyncQueueRepository,
                                JsonProvider jsonProvider,
                                StorageProvider storageProvider) {
        this.dataSyncQueueRepository = dataSyncQueueRepository;
        this.jsonProvider = jsonProvider;
        this.storageProvider = storageProvider;
    }


    @Override
    protected void runCore() {
        Collection<DataSyncQueueEntity> dataSyncQueueEntities = null;
        Date archivedTime = Date.from(Instant.now().minus(1, ChronoUnit.DAYS));
        do {
            dataSyncQueueEntities = this.dataSyncQueueRepository.getDoneSyncQueues(archivedTime, Pageable.ofSize(500)).getContent();
            dataSyncQueueEntities.forEach(it -> {
                deleteFile(it);
                it.makeArchived();
            });

            this.dataSyncQueueRepository.saveAll(dataSyncQueueEntities);
        } while (dataSyncQueueEntities != null && dataSyncQueueEntities.size() > 0);
    }

    @Override
    public String getTaskName() {
        return "clean.sync.file";
    }

    protected void deleteFile(DataSyncQueueEntity syncQueueEntity) {
        SyncDataMeta dataMeta = this.jsonProvider.getData(syncQueueEntity.getData(), SyncDataMeta.class);
        this.storageProvider.remove(dataMeta.getPath());
    }
}
