package com.bcxin.backend.jobs;

import com.bcxin.backend.certificateSignatures.CertificatePushProvider;
import com.bcxin.backend.certificateSignatures.CertificateSignatureProvider;
import com.bcxin.backend.documentSignatrures.SignatureConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

/**
 * 资格认证签章功能定时任务
 */
@Component
@ConditionalOnProperty(prefix = "myapps.pushCertificate",name = "enable",havingValue = "true",matchIfMissing = false)
public class CertificatePushScheduleJob extends ScheduleJobAbstract {
    private final static Logger logger = LoggerFactory.getLogger(CertificatePushScheduleJob.class);
    private final SignatureConfigProperty signatureConfigProperty;

    public CertificatePushScheduleJob(SignatureConfigProperty signatureConfigProperty) {
        this.signatureConfigProperty = signatureConfigProperty;
    }


    /**
     * 解析读取推送章(资格证，文书)的回调信息
     * 针对北京: 采用回调的方式进行处理.
     */
    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void checkCertificatePushCallbackStatus() {
        Collection<CertificatePushProvider> pushProviders
                = this.getBeans(signatureConfigProperty.getSignatureAreaCodes(),
                CertificatePushProvider.class
        );

        if (CollectionUtils.isEmpty(pushProviders)) {
            logger.error("找不到符合实现:{}", signatureConfigProperty.getSignatureAreaCodes());
            return;
        }

        pushProviders.parallelStream().forEach(certificateSignatureProvider -> {
            certificateSignatureProvider.doneForCallback();
        });
    }


    public void pushCertificate() {
    }

}
