/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.backend.core.Blowfish;
import com.bcxin.backend.core.utils.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);
    private static final long EXPIRE_TIME = 259200000L;
    private static final long MOBILE_EXPIRE_TIME = 604800000L;
    public static final String SECRET_KEY = "teemlink_obpm";
    public static final String ACCESS_TOKEN = "accessToken";
    private static Blowfish cipher = null;

    public static String decodeBASE64(String s) {
        if (s == null) {
            return null;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] buffer = decoder.decode(s);
        return new String(buffer);
    }

    public static String encodeToBASE64(String s) {
        if (s == null) {
            return null;
        }
        return SecurityUtil.encodeToBASE64(s.getBytes());
    }

    public static String encodeToBASE64(byte[] obj) {
        if (obj == null) {
            return null;
        }
        Base64.Encoder encoder = Base64.getEncoder();
        String encode = encoder.encodeToString(obj);
        return encode;
    }

    public static String decryptPassword(String encryptedPassword) {
        if (encryptedPassword == null) {
            return null;
        }
        Blowfish cipher = SecurityUtil.getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.decryptString(encryptedPassword);
    }

    public static boolean isEncryptedPassword(String encryptedPassword) {
        try {
            return encryptedPassword != null && encryptedPassword.length() > 0 && SecurityUtil.decryptPassword(encryptedPassword) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Blowfish getCipher() {
        if (cipher != null) {
            return cipher;
        }
        Class<Blowfish> clazz = Blowfish.class;
        synchronized (Blowfish.class) {
            try {
                String keyString = "obpm";
                if (keyString == null) {
                    // empty if block
                }
                cipher = new Blowfish(keyString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return cipher;
        }
    }

    public static String encryptOld(String s) throws Exception {
        return StringUtil.left(SecurityUtil.encodeToMD5(s), 30);
    }

    public static String encodeToMD5(String s) throws NoSuchAlgorithmException {
        if (s == null) {
            return null;
        }
        StringBuffer digstr = new StringBuffer();
        MessageDigest MD = MessageDigest.getInstance("MD5");
        byte[] oldbyte = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            oldbyte[i] = (byte)s.charAt(i);
        }
        MD.update(oldbyte);
        byte[] newbyte = MD.digest(oldbyte);
        for (int i = 0; i < newbyte.length; ++i) {
            digstr.append(newbyte[i]);
        }
        return digstr.toString();
    }

    public static String getToken(String userId) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + 259200000L);
            token = JWT.create().withIssuer("auth0").withClaim("username", userId).withExpiresAt(expiresAt).sign(Algorithm.HMAC256((String)SECRET_KEY));
        }
        catch (Exception e) {
            log.error("getToken\u53d1\u751f\u5f02\u5e38:");
            System.err.println("getToken\u53d1\u751f\u5f02\u5e38:");
            e.printStackTrace();
        }
        return token;
    }

    public static String getMobileToken(String userId) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + 604800000L);
            token = JWT.create().withIssuer("auth0").withClaim("username", userId).withExpiresAt(expiresAt).sign(Algorithm.HMAC256((String)SECRET_KEY));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }

    public static String getUserIdFromTokenWithoutVerify(String token) throws JWTVerificationException {
        Calendar now = Calendar.getInstance();
        now.add(1, 1);
        JWTVerifier verification = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET_KEY)).withIssuer("auth0").acceptNotBefore(now.getTimeInMillis()).acceptExpiresAt(now.getTimeInMillis()).build();
        DecodedJWT jwt = verification.verify(token);
        String userId = jwt.getClaim("username").asString();
        return userId;
    }
}

