/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls.vos;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.exceptions.SaasRetryableException;
import com.bcxin.saas.core.utils.RetryUtil;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateVo {
    public static final String ZHXINXI_HEAD_PHOTO_NOT_EXISTS_YET = "\u56fe\u7247\u68c0\u6d4b\u4e0d\u6b63\u786e";
    private static final Logger logger = LoggerFactory.getLogger(CertificateVo.class);
    private String id;
    private String item_securityname;
    private String item_documentid;
    private String item_idaddress;
    private String item_certificateno;
    private String item_certificatefrom;
    private String item_certificatedate;
    private String item_headphoto;
    private String created;
    private String item_signatured_processed_status;
    private String author;
    private ProcessStatus processStatus;
    private String processResult;
    private String processJson;
    private String _headerPhoto;

    public void assignProcessJson(String processJson) {
        this.setProcessJson(processJson);
    }

    public String getCertificatedate() {
        String certificatedate = this.getItem_certificatedate();
        certificatedate = StringUtils.isEmpty((CharSequence)certificatedate) ? DateUtil.today() : DateUtil.format((Date)DateUtil.parseDate((CharSequence)certificatedate), (String)"yyyy-MM-dd");
        return certificatedate;
    }

    public Short getYearFromIdCard() {
        return IdcardUtil.getYearByIdCard((String)this.getItem_documentid());
    }

    public Short getMonthFromIdCard() {
        return IdcardUtil.getMonthByIdCard((String)this.getItem_documentid());
    }

    public Short getDayFromIdCard() {
        return IdcardUtil.getDayByIdCard((String)this.getItem_documentid());
    }

    public String getHeadPhoto() {
        if (com.bcxin.backend.domain.utils.StringUtils.isEmpty((CharSequence)this._headerPhoto)) {
            String hPhoto = this.getItem_headphoto();
            if (com.bcxin.backend.domain.utils.StringUtils.isEmpty((CharSequence)hPhoto)) {
                return "";
            }
            try {
                JSONArray array = JSONArray.parseArray((String)hPhoto);
                this._headerPhoto = array.stream().map(ii -> ((JSONObject)ii).getString("path")).filter(ii -> !com.bcxin.backend.domain.utils.StringUtils.isEmpty((CharSequence)ii)).findFirst().orElse("");
            }
            catch (Exception ex) {
                logger.error("\u65e0\u6548\u7684\u5934\u50cf\u6570\u636e:id={}, photo={}", (Object)this.getId(), (Object)this.getItem_headphoto());
                return hPhoto;
            }
        }
        return this._headerPhoto;
    }

    public void doCheckIdAddress() {
        String idAddress = this.getItem_idaddress();
        if (com.bcxin.backend.domain.utils.StringUtils.isEmpty((CharSequence)idAddress)) {
            this.setProcessStatus(ProcessStatus.ZHXINXI_ADDERSS);
            this.setProcessResult(ProcessStatus.ZHXINXI_ADDERSS.getText());
        } else if ((idAddress = idAddress.replace("\uff0c", "")).length() < 5) {
            this.setProcessStatus(ProcessStatus.ZHXINXI_ADDERSS);
            this.setProcessResult(String.format("%s-\u8eab\u4efd\u8bc1\u5730\u5740\u65e0\u6548", ProcessStatus.ZHXINXI_ADDERSS.getText()));
        }
    }

    public void doCheckPhoto() {
        String headPhoto = this.getItem_headphoto();
        if (com.bcxin.backend.domain.utils.StringUtils.isEmpty((CharSequence)headPhoto)) {
            this.setProcessStatus(ProcessStatus.ZHXINXI_HEAD_PHOTO);
            this.setProcessResult(String.format("%s-%s.", ProcessStatus.ZHXINXI_HEAD_PHOTO.getText(), headPhoto));
        }
    }

    public boolean doCheck(String urlHead) {
        this.doCheckIdAddress();
        this.doCheckPhoto();
        boolean validData = IdcardUtil.isValidCard((String)this.getItem_documentid());
        if (validData) {
            validData = com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_securityname()) && com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_documentid()) && com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_idaddress()) && com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_certificateno()) && com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_certificatefrom());
        } else {
            logger.error("\u8bc1\u4e66\u6570\u636e(id={})\u7684\u8eab\u4efd\u8bc1\u4fe1\u606f({})\u65e0\u6548", (Object)this.getId(), (Object)this.getItem_documentid());
        }
        if (this.getProcessStatus() == ProcessStatus.SUCCESS && !validData) {
            this.setProcessStatus(ProcessStatus.ZHXINXI_BUQUAN);
            if (!com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_securityname())) {
                this.setProcessResult(String.format("%s-\u59d3\u540d\u4fe1\u606f\u7f3a\u5931", ProcessStatus.ZHXINXI_BUQUAN.getText()));
            } else if (!com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_idaddress())) {
                this.setProcessResult(String.format("%s-\u8eab\u4efd\u8bc1\u5730\u5740\u7f3a\u5931", ProcessStatus.ZHXINXI_BUQUAN.getText()));
            } else if (!com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_certificateno())) {
                this.setProcessResult(String.format("%s-\u8bc1\u4e66\u7f16\u53f7\u7f3a\u5931", ProcessStatus.ZHXINXI_BUQUAN.getText()));
            } else if (!com.bcxin.backend.domain.utils.StringUtils.isNotEmpty((CharSequence)this.getItem_certificatefrom())) {
                this.setProcessResult(String.format("%s-\u53d1\u8bc1\u673a\u5173\u7f3a\u5931", ProcessStatus.ZHXINXI_BUQUAN.getText()));
            }
        } else {
            String cPhoto = this.getHeadPhoto();
            if (com.bcxin.backend.domain.utils.StringUtils.isEmpty((CharSequence)cPhoto)) {
                this.setProcessStatus(ProcessStatus.ZHXINXI_HEAD_PHOTO);
                this.setProcessResult(ProcessStatus.ZHXINXI_HEAD_PHOTO.getText());
            } else {
                String checkPhotoUrl = cPhoto;
                if (!cPhoto.startsWith("http")) {
                    checkPhotoUrl = urlHead + checkPhotoUrl;
                }
                if (!org.springframework.util.StringUtils.hasLength((String)checkPhotoUrl) || checkPhotoUrl.length() < 10 || checkPhotoUrl.contains("[{")) {
                    this.setProcessStatus(ProcessStatus.ZHXINXI_HEAD_PHOTO);
                    this.setProcessResult(String.format("%s:%s", ProcessStatus.ZHXINXI_HEAD_PHOTO.getText(), checkPhotoUrl));
                } else if (!this.doesFileExist(checkPhotoUrl)) {
                    this.setProcessStatus(ProcessStatus.ZHXINXI_HEAD_PHOTO);
                    this.setProcessResult(ZHXINXI_HEAD_PHOTO_NOT_EXISTS_YET);
                }
            }
        }
        return this.getProcessStatus() == ProcessStatus.SUCCESS;
    }

    public boolean doesFileExist(String urlString) {
        try {
            return (Boolean)RetryUtil.execute(() -> {
                HttpResponse response = HttpRequest.get((String)urlString).execute();
                if (response.getStatus() == 200) {
                    return true;
                }
                logger.error("\u56fe\u7247\u68c0\u6d4b\u5931\u8d25\uff1a{};status={}", (Object)urlString, (Object)response.getStatus());
                ThreadUtil.sleep((long)1000L);
                throw new SaasRetryableException(String.format("\u91cd\u8bd5\u68c0\u6d4b\u56fe\u7247\u4fe1\u606f:%s", urlString));
            }, (int)5);
        }
        catch (Exception ex) {
            logger.error("\u91cd\u65b0\u68c0\u6d4b\u4e4b\u540e\uff0c\u8fd8\u662f\u627e\u4e0d\u5230\u56fe\u7247\u4fe1\u606f:{}", (Object)urlString, (Object)ex);
            return false;
        }
    }

    public static CertificateVo create(String id, String item_securityname, String item_documentid, String item_idaddress, String item_certificateno, String item_certificatefrom, String item_certificatedate, String item_headphoto, String created, String item_signatured_processed_status, String author) {
        CertificateVo certificateVo = new CertificateVo();
        certificateVo.setId(id);
        certificateVo.setItem_securityname(item_securityname);
        certificateVo.setItem_documentid(item_documentid);
        certificateVo.setItem_idaddress(item_idaddress);
        certificateVo.setItem_certificateno(item_certificateno);
        certificateVo.setItem_certificatefrom(item_certificatefrom);
        certificateVo.setItem_certificatedate(item_certificatedate);
        certificateVo.setItem_headphoto(item_headphoto);
        certificateVo.setCreated(created);
        certificateVo.setItem_signatured_processed_status(item_signatured_processed_status);
        certificateVo.setProcessStatus(ProcessStatus.SUCCESS);
        certificateVo.setAuthor(author);
        return certificateVo;
    }

    public String getId() {
        return this.id;
    }

    public String getItem_securityname() {
        return this.item_securityname;
    }

    public String getItem_documentid() {
        return this.item_documentid;
    }

    public String getItem_idaddress() {
        return this.item_idaddress;
    }

    public String getItem_certificateno() {
        return this.item_certificateno;
    }

    public String getItem_certificatefrom() {
        return this.item_certificatefrom;
    }

    public String getItem_certificatedate() {
        return this.item_certificatedate;
    }

    public String getItem_headphoto() {
        return this.item_headphoto;
    }

    public String getCreated() {
        return this.created;
    }

    public String getItem_signatured_processed_status() {
        return this.item_signatured_processed_status;
    }

    public String getAuthor() {
        return this.author;
    }

    public ProcessStatus getProcessStatus() {
        return this.processStatus;
    }

    public String getProcessResult() {
        return this.processResult;
    }

    public String getProcessJson() {
        return this.processJson;
    }

    public String get_headerPhoto() {
        return this._headerPhoto;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setItem_securityname(String item_securityname) {
        this.item_securityname = item_securityname;
    }

    public void setItem_documentid(String item_documentid) {
        this.item_documentid = item_documentid;
    }

    public void setItem_idaddress(String item_idaddress) {
        this.item_idaddress = item_idaddress;
    }

    public void setItem_certificateno(String item_certificateno) {
        this.item_certificateno = item_certificateno;
    }

    public void setItem_certificatefrom(String item_certificatefrom) {
        this.item_certificatefrom = item_certificatefrom;
    }

    public void setItem_certificatedate(String item_certificatedate) {
        this.item_certificatedate = item_certificatedate;
    }

    public void setItem_headphoto(String item_headphoto) {
        this.item_headphoto = item_headphoto;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setItem_signatured_processed_status(String item_signatured_processed_status) {
        this.item_signatured_processed_status = item_signatured_processed_status;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setProcessStatus(ProcessStatus processStatus) {
        this.processStatus = processStatus;
    }

    public void setProcessResult(String processResult) {
        this.processResult = processResult;
    }

    public void setProcessJson(String processJson) {
        this.processJson = processJson;
    }

    public void set_headerPhoto(String _headerPhoto) {
        this._headerPhoto = _headerPhoto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertificateVo)) {
            return false;
        }
        CertificateVo other = (CertificateVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$item_securityname = this.getItem_securityname();
        String other$item_securityname = other.getItem_securityname();
        if (this$item_securityname == null ? other$item_securityname != null : !this$item_securityname.equals(other$item_securityname)) {
            return false;
        }
        String this$item_documentid = this.getItem_documentid();
        String other$item_documentid = other.getItem_documentid();
        if (this$item_documentid == null ? other$item_documentid != null : !this$item_documentid.equals(other$item_documentid)) {
            return false;
        }
        String this$item_idaddress = this.getItem_idaddress();
        String other$item_idaddress = other.getItem_idaddress();
        if (this$item_idaddress == null ? other$item_idaddress != null : !this$item_idaddress.equals(other$item_idaddress)) {
            return false;
        }
        String this$item_certificateno = this.getItem_certificateno();
        String other$item_certificateno = other.getItem_certificateno();
        if (this$item_certificateno == null ? other$item_certificateno != null : !this$item_certificateno.equals(other$item_certificateno)) {
            return false;
        }
        String this$item_certificatefrom = this.getItem_certificatefrom();
        String other$item_certificatefrom = other.getItem_certificatefrom();
        if (this$item_certificatefrom == null ? other$item_certificatefrom != null : !this$item_certificatefrom.equals(other$item_certificatefrom)) {
            return false;
        }
        String this$item_certificatedate = this.getItem_certificatedate();
        String other$item_certificatedate = other.getItem_certificatedate();
        if (this$item_certificatedate == null ? other$item_certificatedate != null : !this$item_certificatedate.equals(other$item_certificatedate)) {
            return false;
        }
        String this$item_headphoto = this.getItem_headphoto();
        String other$item_headphoto = other.getItem_headphoto();
        if (this$item_headphoto == null ? other$item_headphoto != null : !this$item_headphoto.equals(other$item_headphoto)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$item_signatured_processed_status = this.getItem_signatured_processed_status();
        String other$item_signatured_processed_status = other.getItem_signatured_processed_status();
        if (this$item_signatured_processed_status == null ? other$item_signatured_processed_status != null : !this$item_signatured_processed_status.equals(other$item_signatured_processed_status)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        ProcessStatus this$processStatus = this.getProcessStatus();
        ProcessStatus other$processStatus = other.getProcessStatus();
        if (this$processStatus == null ? other$processStatus != null : !((Object)((Object)this$processStatus)).equals((Object)other$processStatus)) {
            return false;
        }
        String this$processResult = this.getProcessResult();
        String other$processResult = other.getProcessResult();
        if (this$processResult == null ? other$processResult != null : !this$processResult.equals(other$processResult)) {
            return false;
        }
        String this$processJson = this.getProcessJson();
        String other$processJson = other.getProcessJson();
        if (this$processJson == null ? other$processJson != null : !this$processJson.equals(other$processJson)) {
            return false;
        }
        String this$_headerPhoto = this.get_headerPhoto();
        String other$_headerPhoto = other.get_headerPhoto();
        return !(this$_headerPhoto == null ? other$_headerPhoto != null : !this$_headerPhoto.equals(other$_headerPhoto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CertificateVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $item_securityname = this.getItem_securityname();
        result = result * 59 + ($item_securityname == null ? 43 : $item_securityname.hashCode());
        String $item_documentid = this.getItem_documentid();
        result = result * 59 + ($item_documentid == null ? 43 : $item_documentid.hashCode());
        String $item_idaddress = this.getItem_idaddress();
        result = result * 59 + ($item_idaddress == null ? 43 : $item_idaddress.hashCode());
        String $item_certificateno = this.getItem_certificateno();
        result = result * 59 + ($item_certificateno == null ? 43 : $item_certificateno.hashCode());
        String $item_certificatefrom = this.getItem_certificatefrom();
        result = result * 59 + ($item_certificatefrom == null ? 43 : $item_certificatefrom.hashCode());
        String $item_certificatedate = this.getItem_certificatedate();
        result = result * 59 + ($item_certificatedate == null ? 43 : $item_certificatedate.hashCode());
        String $item_headphoto = this.getItem_headphoto();
        result = result * 59 + ($item_headphoto == null ? 43 : $item_headphoto.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $item_signatured_processed_status = this.getItem_signatured_processed_status();
        result = result * 59 + ($item_signatured_processed_status == null ? 43 : $item_signatured_processed_status.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        ProcessStatus $processStatus = this.getProcessStatus();
        result = result * 59 + ($processStatus == null ? 43 : ((Object)((Object)$processStatus)).hashCode());
        String $processResult = this.getProcessResult();
        result = result * 59 + ($processResult == null ? 43 : $processResult.hashCode());
        String $processJson = this.getProcessJson();
        result = result * 59 + ($processJson == null ? 43 : $processJson.hashCode());
        String $_headerPhoto = this.get_headerPhoto();
        result = result * 59 + ($_headerPhoto == null ? 43 : $_headerPhoto.hashCode());
        return result;
    }

    public String toString() {
        return "CertificateVo(id=" + this.getId() + ", item_securityname=" + this.getItem_securityname() + ", item_documentid=" + this.getItem_documentid() + ", item_idaddress=" + this.getItem_idaddress() + ", item_certificateno=" + this.getItem_certificateno() + ", item_certificatefrom=" + this.getItem_certificatefrom() + ", item_certificatedate=" + this.getItem_certificatedate() + ", item_headphoto=" + this.getItem_headphoto() + ", created=" + this.getCreated() + ", item_signatured_processed_status=" + this.getItem_signatured_processed_status() + ", author=" + this.getAuthor() + ", processStatus=" + (Object)((Object)this.getProcessStatus()) + ", processResult=" + this.getProcessResult() + ", processJson=" + this.getProcessJson() + ", _headerPhoto=" + this.get_headerPhoto() + ")";
    }

    public static enum ProcessStatus {
        ZHXINXI_BUQUAN{

            @Override
            public String getText() {
                return "\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168";
            }

            @Override
            public String getSql() {
                return "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168'";
            }
        }
        ,
        ZHXINXI_ADDERSS{

            @Override
            public String getText() {
                return "\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09";
            }

            @Override
            public String getSql() {
                return "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09'";
            }
        }
        ,
        ZHXINXI_HEAD_PHOTO{

            @Override
            public String getText() {
                return "\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\uff09";
            }

            @Override
            public String getSql() {
                return "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\uff09'";
            }
        }
        ,
        ZHXINXI_HEAD_PHOTO_ADDRESS{

            @Override
            public String getText() {
                return "\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\u3001\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09";
            }

            @Override
            public String getSql() {
                return "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\u3001\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09'";
            }
        }
        ,
        SUCCESS{

            @Override
            public String getText() {
                return "\u6570\u636e\u6b63\u786e";
            }

            @Override
            public String getSql() {
                return "UPDATE tlk_certificate SET ITEM_last_signatured_processed_result = '',ITEM_signatured_processed_status = 1,ITEM_signatured_operator = '\"+operator+\"',ITEM_signatured_time = now(),ITEM_CERTIFICATEDATE = IFNULL(ITEM_CERTIFICATEDATE, NOW())";
            }
        };


        public abstract String getText();

        public abstract String getSql();

        public String getInsertSql() {
            return "INSERT INTO obpm2_security.signature_queues (version,template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES(?,?,?,?,?,?,?,?)";
        }
    }
}

