package com.bcxin.backend.core.utils;

import java.util.HashMap;
import java.util.Map;

public class ThreadRequestUtil {
    private final static ThreadLocal<Map<String,Object>> threadRequestContainer = new ThreadLocal<>();
    private final static String IS_JUST_QUERY_COUNT_KEY="IS_JUST_QUERY_COUNT_KEY";
    public static void setIsJustQueryCount(boolean ignoredQueryData) {
        Map<String, Object> container = getThreadRequestContainer();

        container.put(IS_JUST_QUERY_COUNT_KEY, ignoredQueryData);

        threadRequestContainer.set(container);
    }

    public static boolean getIsJustQueryCount() {
        Map<String, Object> container = getThreadRequestContainer();
        return container.containsKey(IS_JUST_QUERY_COUNT_KEY) &&
                (boolean) container.get(IS_JUST_QUERY_COUNT_KEY);
    }

    private static Map<String,Object> getThreadRequestContainer() {
        Map<String, Object> container = threadRequestContainer.get();
        if (container == null) {
            synchronized (ThreadRequestUtil.class) {
                container = threadRequestContainer.get();
                if (container == null) {
                    container = new HashMap<>();

                    threadRequestContainer.set(container);
                }
            }
        }

        return container;
    }

    public static void setIsFeatureEnabled(String featureKey, boolean enable) {
        Map<String, Object> container = getThreadRequestContainer();

        container.put(featureKey, enable);

        threadRequestContainer.set(container);
    }

    public static boolean getIsFeatureEnabled(String featureKey) {
        Map<String, Object> container = getThreadRequestContainer();
        return container.containsKey(featureKey) &&
                (boolean) container.get(featureKey);
    }
}
