package com.bcxin.backend.core.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.backend.core.Blowfish;
import lombok.extern.slf4j.Slf4j;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;

@Slf4j
public class SecurityUtil {
    private static final long EXPIRE_TIME = 3 * 24 * 60 * 60 * 1000;

    private static final long MOBILE_EXPIRE_TIME = 7 *24* 60 * 60 * 1000;

    public static final String SECRET_KEY = "teemlink_obpm";
    public static final String ACCESS_TOKEN = "accessToken";

    /**
     * BASE64 解码
     *
     * @param s
     * @return
     */
    public static String decodeBASE64(String s) {
        if (s == null)
            return null;
        // 从JKD 9开始rt.jar包已废除，从JDK 1.8开始使用java.util.Base64.Decoder
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] buffer = decoder.decode(s);
        return new String(buffer);
    }

    /**
     * BASE64 编码
     *
     * @param s
     * @return
     */
    public static String encodeToBASE64(String s) {
        if (s == null)
            return null;
        return encodeToBASE64(s.getBytes());
    }

    /**
     * BASE64 编码
     *
     * @param obj
     * @return
     */
    public static String encodeToBASE64(byte[] obj) {
        if (obj == null)
            return null;
        Base64.Encoder encoder = Base64.getEncoder();
        String encode = encoder.encodeToString(obj);
        return encode;
    }

    public static String decryptPassword(String encryptedPassword) {
        if (encryptedPassword == null) {
            return null;
        }
        Blowfish cipher = getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.decryptString(encryptedPassword);
    }

    public static boolean isEncryptedPassword(String encryptedPassword) {
        try {
            return encryptedPassword != null && encryptedPassword.length() > 0 && decryptPassword(encryptedPassword) != null;
        } catch (Exception ex) {
            return false;
        }
    }

    private static Blowfish cipher = null;
    private static  Blowfish getCipher() {
        if (cipher != null) {
            return cipher;
        }
        // Get the password key, stored as a database property. Obviously,
        // protecting your database is critical for making the
        // encryption fully secure.

        synchronized (Blowfish.class) {
            String keyString;
            try {
                keyString = "obpm";
                if (keyString == null) {
                    // Check to make sure that setting the property worked. It won't
                    // work,
                    // for example, when in setup mode.
                }
                cipher = new Blowfish(keyString);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return cipher;
        }
    }

    /**
     * 旧的密码加密机制(主要用于登录)
     *
     * @param s
     * @return
     * @throws Exception
     */
    public static String encryptOld(final String s) throws Exception {
        return StringUtil.left(SecurityUtil.encodeToMD5(s), 30);
    }

    /**
     * Encrypt the string with the MD5 arithmetic
     *
     * @param s
     *            Normal message that you want to convert.
     * @return The Encrypt string.
     * @throws NoSuchAlgorithmException
     * @throws Exception
     */
    public static String encodeToMD5(String s) throws NoSuchAlgorithmException {
        if (s == null)
            return null;
        StringBuffer digstr = new StringBuffer();
        MessageDigest MD = MessageDigest.getInstance("MD5");

        byte[] oldbyte = new byte[s.length()];
        for (int i = 0; i < s.length(); i++) {
            oldbyte[i] = (byte) s.charAt(i);
        }
        MD.update(oldbyte);
        byte[] newbyte = MD.digest(oldbyte);
        for (int i = 0; i < newbyte.length; i++) {
            digstr.append(newbyte[i]);
        }

        return digstr.toString();
    }

    public static String getToken(String userId){

        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + EXPIRE_TIME);
            token = JWT.create()
                    .withIssuer("auth0")
                    .withClaim("username", userId)
                    .withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e) {
            log.error("getToken发生异常:");
            System.err.println("getToken发生异常:");
            e.printStackTrace();
        }

        return token;

    }

    public static String getMobileToken(String userId){
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + MOBILE_EXPIRE_TIME);
            token = JWT.create()
                    .withIssuer("auth0")
                    .withClaim("username", userId)
                    .withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e){
            e.printStackTrace();
        }
        return token;

    }

    public static String getUserIdFromTokenWithoutVerify(String token) throws JWTVerificationException {
        Calendar now = Calendar.getInstance();
        now.add(Calendar.YEAR, 1);
        JWTVerifier verification = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0")
                .acceptNotBefore(now.getTimeInMillis())
                .acceptExpiresAt(now.getTimeInMillis()).build();
        DecodedJWT jwt = verification.verify(token);
        String userId = jwt.getClaim("username").asString();

        return userId;
    }
}
