package com.bcxin.backend.core.utils;

import cn.hutool.core.util.StrUtil;

import java.util.ArrayList;

public class ComponentUtils {
    private static ArrayList<String> staticResourceArray = new ArrayList();
    static {
        staticResourceArray.add(".png");
        staticResourceArray.add(".jpg");
        staticResourceArray.add(".jpeg");
        staticResourceArray.add("/images/");
        staticResourceArray.add(".js");
        staticResourceArray.add(".css");
        staticResourceArray.add(".html");
        staticResourceArray.add(".xlsx");
        staticResourceArray.add("actuator/health");
        staticResourceArray.add("actuator/httptrace");
        staticResourceArray.add("actuator/metrics");
    }

    public static boolean isFilterIgnored(String uri) {
        if (StrUtil.isBlank(uri)) {
            return false;
        }
        if (staticResourceArray.stream().anyMatch(ii -> {
            return StrUtil.containsAny(uri, ii);
        })) {
            return true;
        }

        return false;
    }
}
