package com.bcxin.backend.core.components;

import com.alibaba.fastjson.JSON;

public interface JsonProvider {
    <T> T getData(String json, Class<T> tClass);

    <T> String getJson(T data);

    static class JsonProviderImpl implements JsonProvider {
        @Override
        public <T> T getData(String json, Class<T> tClass) {
            return JSON.parseObject(json, tClass);
        }

        @Override
        public <T> String getJson(T data) {
            return JSON.toJSONString(data);
        }
    }
}
