package com.bcxin.backend.core;

import cn.hutool.core.collection.CollectionUtil;
import lombok.Getter;

import java.util.Collection;


@Getter
public class AppConfigProperty {
    private final String rootPath;
    private final String domainUrl;
    private final Collection<String> proxiedTargets;
    private final String outRequsetDirKey;

    public AppConfigProperty(String rootPath, String domainUrl, Collection<String> proxiedTargets, String outRequsetDirKey) {
        this.rootPath = rootPath;
        this.domainUrl = domainUrl;
        this.proxiedTargets = proxiedTargets;
        this.outRequsetDirKey = outRequsetDirKey;
    }

    public static AppConfigProperty create(String rootPath, String domainUrl, Collection<String> proxiedTargets, String outRequsetDirKey) {
        return new AppConfigProperty(rootPath, domainUrl, proxiedTargets, outRequsetDirKey);
    }

    public boolean isSyncViaFtp(String targetApp) {
        if (CollectionUtil.isEmpty(proxiedTargets)) {
            return true;
        }

        if (proxiedTargets.contains(targetApp)) {
            return false;
        }

        return true;
    }
}
